<?php
/**
 * Neon template - Cyberpunk with glow effects
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/neon.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-neon' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="glow-dot glow-dot-1"></div>
    <div class="glow-dot glow-dot-2"></div>
    <div class="glow-dot glow-dot-3"></div>
    <div class="glow-dot glow-dot-4"></div>

    <div class="maintenance-container">
        <div class="corner corner-tl"></div>
        <div class="corner corner-tr"></div>
        <div class="corner corner-bl"></div>
        <div class="corner corner-br"></div>

        <div class="maintenance-content">
            <?php echo wp_kses_post( $message ); ?>
        </div>

        <div class="site-name">
            <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
        </div>
    </div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
