<?php
/**
 * Nature template - Organic with leaf elements
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/nature.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-nature' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="leaf leaf-1">&#127807;</div>
    <div class="leaf leaf-2">&#127811;</div>
    <div class="leaf leaf-3">&#127793;</div>
    <div class="leaf leaf-4">&#127807;</div>

    <div class="maintenance-container">
        <div class="green-bar"></div>
        <div class="content-inner">
            <div class="nature-icon">&#127795;</div>

            <div class="maintenance-content">
                <?php echo wp_kses_post( $message ); ?>
            </div>

            <div class="site-name">
                <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
            </div>
        </div>
    </div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
