<?php
/**
 * Gradient Wave template - Animated CSS wave at bottom
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/gradient-wave.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-gradient-wave' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-content">
            <?php echo wp_kses_post( $message ); ?>
        </div>

        <div class="site-name">
            <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
        </div>
    </div>

    <div class="waves">
        <div class="wave wave-1"></div>
        <div class="wave wave-2"></div>
        <div class="wave wave-3"></div>
    </div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
