<?php
/**
 * Countdown template - Large timer placeholder
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/countdown.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-countdown' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-content">
            <?php echo wp_kses_post( $message ); ?>
        </div>

        <div class="countdown-container">
            <div class="countdown-item">
                <div class="countdown-value" id="days">00</div>
                <div class="countdown-label"><?php esc_html_e( 'Days', 'devlab-maintenance-mode' ); ?></div>
            </div>
            <span class="countdown-separator">:</span>
            <div class="countdown-item">
                <div class="countdown-value" id="hours">00</div>
                <div class="countdown-label"><?php esc_html_e( 'Hours', 'devlab-maintenance-mode' ); ?></div>
            </div>
            <span class="countdown-separator">:</span>
            <div class="countdown-item">
                <div class="countdown-value" id="minutes">00</div>
                <div class="countdown-label"><?php esc_html_e( 'Minutes', 'devlab-maintenance-mode' ); ?></div>
            </div>
            <span class="countdown-separator">:</span>
            <div class="countdown-item">
                <div class="countdown-value" id="seconds">00</div>
                <div class="countdown-label"><?php esc_html_e( 'Seconds', 'devlab-maintenance-mode' ); ?></div>
            </div>
        </div>

        <div class="site-name">
            <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
        </div>
    </div>

    <?php wp_print_scripts( 'mmbd-countdown' ); ?>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
