<?php
/**
 * Construction template - Warning theme with diagonal stripes
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/construction.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-construction' ); ?>
    <?php do_action( 'mmbd_maintenance_head' ); ?>
</head>
<body>
    <div class="stripe-bar"></div>

    <div class="main-content">
        <div class="maintenance-container">
            <div class="warning-icon">
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L1 21h22L12 2z" fill="#f39c12"/>
                    <path d="M12 9v5M12 17v.01" stroke="#2c3e50" stroke-width="2" stroke-linecap="round"/>
                </svg>
            </div>

            <div class="maintenance-content">
                <?php echo wp_kses_post( $message ); ?>
            </div>

            <div class="site-name">
                <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
            </div>
        </div>
    </div>

    <div class="stripe-bar"></div>

    <?php do_action( 'mmbd_maintenance_footer' ); ?>
</body>
</html>
