<?php
/**
 * Classic template - Clean card with purple gradient
 *
 * This template can be overridden by copying it to:
 * your-theme/devlab-maintenance-mode/classic.php
 *
 * @package DevLabMaintenanceMode
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// $message variable is available from the display_maintenance_page() method
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo esc_html( get_bloginfo( 'name' ) ); ?> - <?php esc_html_e( 'Maintenance', 'devlab-maintenance-mode' ); ?></title>
    <?php wp_print_styles( 'mmbd-template-classic' ); ?>
    <?php
    /**
     * Fires in the head section of the maintenance page
     */
    do_action( 'mmbd_maintenance_head' );
    ?>
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M22.7 19l-9.1-9.1c.9-2.3.4-5-1.5-6.9-2-2-5-2.4-7.4-1.3L9 6 6 9 1.6 4.7C.4 7.1.9 10.1 2.9 12.1c1.9 1.9 4.6 2.4 6.9 1.5l9.1 9.1c.4.4 1 .4 1.4 0l2.3-2.3c.5-.4.5-1.1.1-1.4z"/>
            </svg>
        </div>

        <div class="maintenance-content">
            <?php echo wp_kses_post( $message ); ?>
        </div>

        <div class="site-name">
            <?php echo esc_html( get_bloginfo( 'name' ) ); ?>
        </div>
    </div>

    <?php
    /**
     * Fires at the end of the maintenance page body
     */
    do_action( 'mmbd_maintenance_footer' );
    ?>
</body>
</html>
