<?php
/**
 * Template registry for DevLab Maintenance Mode
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class MMBD_Templates {

    public static function get_templates() {
        $templates = array(
            'classic' => array(
                'name'        => __( 'Classic', 'devlab-maintenance-mode' ),
                'description' => __( 'Clean card with purple gradient', 'devlab-maintenance-mode' ),
                'colors'      => array( '#667eea', '#764ba2' ),
            ),
            'minimal-dark' => array(
                'name'        => __( 'Minimal Dark', 'devlab-maintenance-mode' ),
                'description' => __( 'Ultra minimal dark mode design', 'devlab-maintenance-mode' ),
                'colors'      => array( '#1a1a2e', '#00d9ff' ),
            ),
            'construction' => array(
                'name'        => __( 'Construction', 'devlab-maintenance-mode' ),
                'description' => __( 'Warning theme with stripes', 'devlab-maintenance-mode' ),
                'colors'      => array( '#f39c12', '#2c3e50' ),
            ),
            'gradient-wave' => array(
                'name'        => __( 'Gradient Wave', 'devlab-maintenance-mode' ),
                'description' => __( 'Animated wave at bottom', 'devlab-maintenance-mode' ),
                'colors'      => array( '#00b4db', '#6441a5' ),
            ),
            'corporate' => array(
                'name'        => __( 'Corporate', 'devlab-maintenance-mode' ),
                'description' => __( 'Professional business design', 'devlab-maintenance-mode' ),
                'colors'      => array( '#2c3e50', '#d4af37' ),
            ),
            'playful' => array(
                'name'        => __( 'Playful', 'devlab-maintenance-mode' ),
                'description' => __( 'Fun with floating shapes', 'devlab-maintenance-mode' ),
                'colors'      => array( '#ff6b9d', '#ffc93c' ),
            ),
            'neon' => array(
                'name'        => __( 'Neon', 'devlab-maintenance-mode' ),
                'description' => __( 'Cyberpunk with glow effects', 'devlab-maintenance-mode' ),
                'colors'      => array( '#0a0a0a', '#ff00ff' ),
            ),
            'nature' => array(
                'name'        => __( 'Nature', 'devlab-maintenance-mode' ),
                'description' => __( 'Organic with leaf elements', 'devlab-maintenance-mode' ),
                'colors'      => array( '#2d5a27', '#f5f5dc' ),
            ),
            'tech' => array(
                'name'        => __( 'Tech', 'devlab-maintenance-mode' ),
                'description' => __( 'Digital terminal aesthetic', 'devlab-maintenance-mode' ),
                'colors'      => array( '#0f0f23', '#00ff00' ),
            ),
            'countdown' => array(
                'name'        => __( 'Countdown', 'devlab-maintenance-mode' ),
                'description' => __( 'Large timer placeholder', 'devlab-maintenance-mode' ),
                'colors'      => array( '#1a1a2e', '#ff6b35' ),
            ),
        );

        return apply_filters( 'mmbd_templates', $templates );
    }

    public static function get_template( $id ) {
        $templates = self::get_templates();
        return isset( $templates[ $id ] ) ? $templates[ $id ] : null;
    }

    public static function get_template_path( $id ) {
        $templates = self::get_templates();

        if ( ! isset( $templates[ $id ] ) ) {
            $id = 'classic';
        }

        $theme_template = locate_template( 'devlab-maintenance-mode/' . $id . '.php' );
        if ( $theme_template ) {
            return $theme_template;
        }

        $plugin_template = MMBD_PLUGIN_DIR . 'templates/' . $id . '.php';
        if ( file_exists( $plugin_template ) ) {
            return $plugin_template;
        }

        $classic = MMBD_PLUGIN_DIR . 'templates/classic.php';
        return file_exists( $classic ) ? $classic : false;
    }

    public static function get_preview_url( $id ) {
        $templates = self::get_templates();
        if ( ! isset( $templates[ $id ] ) ) {
            $id = 'classic';
        }
        return MMBD_PLUGIN_URL . 'assets/images/templates/' . $id . '.svg';
    }

    public static function get_default_template() {
        return 'classic';
    }

    public static function validate_template_id( $id ) {
        $templates = self::get_templates();
        return isset( $templates[ $id ] ) ? $id : 'classic';
    }
}
