<?php
/**
 * Plugin Name: DevLab Maintenance Mode
 * Plugin URI: https://codersground.com
 * Description: A lightweight maintenance mode plugin with 10 beautiful templates, role-based bypass, IP whitelist, and secret phrase access.
 * Version: 1.0.2
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Author: CodersGround
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: devlab-maintenance-mode
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'MMBD_VERSION', '1.0.2' );
define( 'MMBD_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'MMBD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'MMBD_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

function mmbd_get_default_settings() {
    return array(
        'enabled'         => false,
        'message'         => __( '<h1>We\'ll be back soon!</h1><p>We are currently performing scheduled maintenance. Please check back shortly.</p>', 'devlab-maintenance-mode' ),
        'bypass_roles'    => array( 'administrator' ),
        'ip_whitelist'    => '',
        'secret_phrase'   => '',
        'cookie_duration' => 1,
        'template'        => 'classic',
        'countdown_date'  => '',
        'analytics_id'       => '',
        'social_facebook'    => '',
        'social_twitter'     => '',
        'social_instagram'   => '',
        'social_linkedin'    => '',
        'version'         => MMBD_VERSION,
    );
}

function mmbd_get_settings() {
    $defaults = mmbd_get_default_settings();
    $settings = get_option( 'mmbd_settings', array() );
    return wp_parse_args( $settings, $defaults );
}

function mmbd_activate() {
    if ( false === get_option( 'mmbd_settings' ) ) {
        add_option( 'mmbd_settings', mmbd_get_default_settings() );
    }
}
register_activation_hook( __FILE__, 'mmbd_activate' );

function mmbd_init() {
    require_once MMBD_PLUGIN_DIR . 'includes/class-mmbd-templates.php';
    require_once MMBD_PLUGIN_DIR . 'includes/class-mmbd-maintenance.php';

    if ( is_admin() ) {
        require_once MMBD_PLUGIN_DIR . 'includes/class-mmbd-admin.php';
    }
}
add_action( 'plugins_loaded', 'mmbd_init', 5 );
