( function() {
    'use strict';

    var endTime;

    if ( typeof mmbdCountdown !== 'undefined' && mmbdCountdown.targetDate ) {
        endTime = new Date( mmbdCountdown.targetDate ).getTime();
    } else {
        endTime = new Date().getTime() + ( 2 * 24 * 60 * 60 * 1000 );
    }

    function updateCountdown() {
        var now = new Date().getTime();
        var distance = endTime - now;

        if ( distance < 0 ) {
            document.getElementById( 'days' ).textContent = '00';
            document.getElementById( 'hours' ).textContent = '00';
            document.getElementById( 'minutes' ).textContent = '00';
            document.getElementById( 'seconds' ).textContent = '00';
            return;
        }

        var days = Math.floor( distance / ( 1000 * 60 * 60 * 24 ) );
        var hours = Math.floor( ( distance % ( 1000 * 60 * 60 * 24 ) ) / ( 1000 * 60 * 60 ) );
        var minutes = Math.floor( ( distance % ( 1000 * 60 * 60 ) ) / ( 1000 * 60 ) );
        var seconds = Math.floor( ( distance % ( 1000 * 60 ) ) / 1000 );

        document.getElementById( 'days' ).textContent = days.toString().padStart( 2, '0' );
        document.getElementById( 'hours' ).textContent = hours.toString().padStart( 2, '0' );
        document.getElementById( 'minutes' ).textContent = minutes.toString().padStart( 2, '0' );
        document.getElementById( 'seconds' ).textContent = seconds.toString().padStart( 2, '0' );
    }

    updateCountdown();
    setInterval( updateCountdown, 1000 );
} )();
