( function() {
    var radios = document.querySelectorAll( '.mmbd-template-radio' );
    var countdownRow = document.getElementById( 'mmbd_countdown_date' );

    if ( countdownRow ) {
        countdownRow = countdownRow.closest( 'tr' );
    }

    function toggleCountdownField( value ) {
        if ( ! countdownRow ) {
            return;
        }
        countdownRow.style.display = ( value === 'countdown' ) ? '' : 'none';
    }

    radios.forEach( function( radio ) {
        radio.addEventListener( 'change', function() {
            document.querySelectorAll( '.mmbd-template-card' ).forEach( function( card ) {
                card.classList.remove( 'mmbd-template-selected' );
            } );
            this.closest( '.mmbd-template-card' ).classList.add( 'mmbd-template-selected' );
            toggleCountdownField( this.value );
        } );
    } );

    var checked = document.querySelector( '.mmbd-template-radio:checked' );
    if ( checked ) {
        toggleCountdownField( checked.value );
    }
} )();
