const path = require('path');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

module.exports = {
    entry: {
        main: './assets/src/js/main.js',
        develux_bulk: './assets/src/js/bulk/DeveluxBulkProcessing',
        help_notice: './assets/src/js/helpNotice.js',
        external: './assets/src/js/external.js',
        deactivate: './assets/src/js/deactivate/deactivate.js',
        develux_frontend: './assets/src/scss/develux_frontend.scss',
    },
    output: {
        path: path.resolve(__dirname, 'assets/dist'),
        filename: '[name].js',
    },
    module: {
        rules: [
            {
                test: /\.js$/,
                exclude: /node_modules/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['@babel/preset-env'],
                    },
                },
            },
            {
                test: /\.scss$/,
                use: [
                    MiniCssExtractPlugin.loader, // Extracts CSS into a separate file
                    'css-loader',                // Translates CSS into CommonJS
                    'sass-loader',               // Compiles Sass to CSS
                ],
            },
        ],
    },
    plugins: [
        new MiniCssExtractPlugin({
            filename: '[name].css', // Output filename for the CSS file
        }),
    ],
    externals: {
        jquery: 'jQuery', // Assumes `jQuery` will be available globally
        'jquery-ui': 'jQuery.ui',
    },
};
