<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * @var $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
$renderer = $data['renderer'] ?? null;
if (!$post || !$renderer) {
    return;
}
if (!function_exists('wc_get_product')) {
    echo '<p>' . esc_html__('WooCommerce not installed', 'devellux-sales-countdown-timer-builder') . '</p>';
    return;
}
$sale_start = get_post_meta($post->ID, '_sale_price_dates_from', true) ?? 0;
$sale_end = get_post_meta($post->ID, '_sale_price_dates_to', true) ?? 0;
$text_editor_svg = SVG_Generator::generate_text_editor_icons();
$button_svg = SVG_Generator::generate_button_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();
?>



<div>
    <h2>Timer Style Settings</h2>
    <p>Use this section to customize your timer.</p>
</div>
    <fieldset class="flex w-full flex-wrap flex-col gap-5 label-block-styles pt-15">
        <div class="w-full flex flex-wrap flex-col gap">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Title size',
                'key' => 'develux_font_size_timer_title',
                'id' => 'develux-font-size-timer-title',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'rem',
                'default_value' => 1.3,
                'min' => 0.5,
                'max' => 3,
                'step' => 0.1,
                'data_property' => 'font-size,line-height',
                'data_dimension_unit_type' => 'rem',
                'data_target' => '.countdown-timer-title-js',
                'tooltip'=>'Sets the text size for title',
                'data_depended_target_value' => '#develux-time-title-font-unit',
                'unit_data' => [
                    'key' => 'develux_time_title_font_unit',
                    'id' => 'develux-time-title-font-unit',
                    'options' => [
                        'rem' => 'rem',
                        'em' => 'em',
                    ]
                ]
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/select', [
                'post' => $post,
                'legend' => 'Title weight',
                'key' => 'develux_font_weight_timer_title',
                'id' => 'develux-font-weight-timer_title',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'default_value' => 700,
                'items' => 'start',
                'placeholder' => '',
                'options' => [
                    '100' => '100 - Extra Light',
                    '200' => '200 - Light',
                    '300' => '300 - Thin',
                    '400' => '400 - Regular',
                    '500' => '500 - Medium',
                    '600' => '600 - SemiBold',
                    '700' => '700 - Bold',
                    '800' => '800 - ExtraBold',
                    '900' => '900 - Boldest',
                ],
                'tooltip'=>'Sets the bold for title',
                'data_property' => 'font-weight',
                'data_dimension_unit_type' => '',
                'data_target' => '.countdown-timer-title-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/radiobuttons', [
                'post' => $post,
                'legend' => 'Title style',
                'key' => 'develux_font_style_timer_title',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'items-start',
                'default_value' => 'normal',
                'options' => [
                    [
                        'id' => 'develux-font-style-timer_title',
                        'value' => 'normal',
                        'label' => 'Normal',
                    ],
                    [
                        'id' => 'develux-font-style-timer_title-2',
                        'value' => 'italic',
                        'label' => 'Italic',
                    ],

                ],
                'tooltip'=>'Sets the text style for title',
                'data_property' => 'font-style',
                'data_dimension_unit_type' => '',
                'data_target' => '.countdown-timer-title-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/color', [
                'post' => $post,
                'legend' => 'Title color',
                'key' => 'develux_font_color_timer_title',
                'id' => 'develux-font-color-timer_title',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'default_value' => '#ffffff',
                'items' => 'start',
                'tooltip'=>'Sets the text color for title',
                'data_property' => 'color',
                'data_dimension_unit_type' => '',
                'data_target' => '.countdown-timer-title-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/select', [
                'post' => $post,
                'legend' => 'Title align',
                'key' => 'develux_timer_title_text_align',
                'id' => 'develux-timer-title-text-align',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'items-start',
                'default_value' => 'center',
                'options' => [
                        'start' => 'Start',
                        'center' => 'Center',
                        'end' => 'End',
                ],
                'tooltip'=>'Sets the title alignment start/ center/ left ',
                'data_property' => 'text-align',
                'data_dimension_unit_type' => '',
                'data_target' => '.countdown-timer-title-js'
            ]), $allowed_html);
            ?>
        </div>
    </fieldset>
    <div class="mt-15 w-full flex-wrap flex flex-col gap mt-15">
        <?php
        echo wp_kses($renderer->render('tabs/number', [
            'post' => $post,
            'legend' => 'Text size',
            'key' => 'develux_time_title_font_size',
            'id' => 'develux-time-title-font-size',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'col',
            'placeholder' => 'rem',
            'items' => 'items-start',
            'default_value' => 0.8,
            'min' => 0.5,
            'max' => 3,
            'step' => 0.1,
            'tooltip'=>'Sets the text size',
            'data_property' => 'font-size,line-height',
            'data_dimension_unit_type' => 'rem',
            'data_target' => '.counter-title',
            'data_depended_target_value' => '#develux-time-title-font-size-unit',
            'unit_data' => [
                'key' => 'develux_time_title_font_size_unit',
                'id' => 'develux-time-title-font-size-unit',
                'options' => [
                    'rem' => 'rem',
                    'em' => 'em',
                ]
            ]
        ]), $allowed_html);
        echo wp_kses($renderer->render('tabs/radiobuttons', [
            'post' => $post,
            'legend' => 'Text style',
            'key' => 'develux_time_title_font_style',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'row',
            'items' => 'items-start',
            'default_value' => 'normal',
            'tooltip'=>'Sets the text  style',
            'options' => [
                [
                    'id' => 'develux-time-title-font-style',
                    'value' => 'normal',
                    'label' => 'Normal',
                ],
                [
                    'id' => 'develux-time-title-font-style-2',
                    'value' => 'italic',
                    'label' => 'Italic',
                ],

            ],
            'data_property' => 'font-style',
            'data_dimension_unit_type' => '',
            'data_target' => '.counter-title'
        ]), $allowed_html);
        echo wp_kses($renderer->render('tabs/select', [
            'post' => $post,
            'legend' => 'Text weight',
            'key' => 'develux_time_title_font_weight',
            'id' => 'develux-timer-font-weight',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'col',
            'default_value' => 400,
            'items' => 'start',
            'tooltip'=>'Sets the text weight',
            'placeholder' => '',
            'options' => [
                '100' => '100 - Extra Light',
                '200' => '200 - Light',
                '300' => '300 - Thin',
                '400' => '400 - Regular',
                '500' => '500 - Medium',
                '600' => '600 - SemiBold',
                '700' => '700 - Bold',
                '800' => '800 - ExtraBold',
                '900' => '900 - Boldest',
            ],
            'data_property' => 'font-weight',
            'data_dimension_unit_type' => '',
            'data_target' => '.counter-title'
        ]), $allowed_html);
        echo wp_kses($renderer->render('tabs/color', [
            'post' => $post,
            'legend' => 'Text color',
            'key' => 'develux_time_title_font_color',
            'id' => 'develux-timer-font-color',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'col',
            'items' => 'start',
            'default_value' => '#62096d',
            'data_property' => 'color',
            'data_dimension_unit_type' => '',
            'tooltip'=>'Sets the text  color',
            'data_target' => '.counter-title'
        ]), $allowed_html);
        ?>
    </div>
    <div>
        <h2>Countdown timer styling</h2>
        <p>Here you can set parameters</p>
    </div>
    <fieldset class="flex flex-row flex-wrap gap mt-15">
        <div class="w-full flex flex-row flex-wrap gap">
            <?php
            echo wp_kses($renderer->render('tabs/checkbox', [
                'post' => $post,
                'legend' => 'Use animation for timer',
                'key' => 'develux_timer_display_animation',
                'id' => 'develux-timer-display-animation',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'tooltip'=>'Allows to animate the time change on the timer',
                'items' => 'start',
            ]), $allowed_html);
            ?>
        </div>
        <div class="w-full flex-wrap flex gap flex-col">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Numbers size',
                'key' => 'develux_timer_font_size',
                'id' => 'develux-font-size-timer-title',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'rem',
                'default_value' => 1.3,
                'tooltip'=>'Sets the timer number size',
                'min' => 0.5,
                'max' => 3,
                'step' => 0.1,
                'data_property' => 'font-size,line-height',
                'data_dimension_unit_type' => 'rem',
                'data_target' => '.countnum',
                'data_depended_target_value' => '#develux-timer-font-size-unit',
                'unit_data' => [
                    'key' => 'develux_timer_font_size_unit',
                    'id' => 'develux-timer-font-size-unit',
                    'options' => [
                        'rem' => 'rem',
                        'em' => 'em',
                    ]
                ]
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/radiobuttons', [
                'post' => $post,
                'legend' => 'Numbers style',
                'key' => 'develux_timer_font_style',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'items-start',
                'default_value' => 'normal',
                'tooltip'=>'Sets the timer number style',
                'options' => [
                    [
                        'id' => 'develux-timer-font-style',
                        'value' => 'normal',
                        'label' => 'Normal',
                    ],
                    [
                        'id' => 'develux-timer-font-style-2',
                        'value' => 'italic',
                        'label' => 'Italic',
                    ],

                ],
                'data_property' => 'font-style',
                'data_dimension_unit_type' => '',
                'data_target' => '.countnum'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/select', [
                'post' => $post,
                'legend' => 'Numbers weight',
                'key' => 'develux_timer_font_weight',
                'id' => 'develux-timer-font-weight',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'start',
                'placeholder' => '',
                'tooltip'=>'Sets the timer number weight',
                'default_value' => 400,
                'options' => [
                    '100' => '100 - Extra Light',
                    '200' => '200 - Light',
                    '300' => '300 - Thin',
                    '400' => '400 - Regular',
                    '500' => '500 - Medium',
                    '600' => '600 - SemiBold',
                    '700' => '700 - Bold',
                    '800' => '800 - ExtraBold',
                    '900' => '900 - Boldest',
                ],
                'data_property' => 'font-weight',
                'data_dimension_unit_type' => '',
                'data_target' => '.countnum'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/color', [
                'post' => $post,
                'legend' => 'Numbers color',
                'key' => 'develux_timer_font_color',
                'id' => 'develux-timer-font-color',
                'class_name' => 'develux-input-js',
                'tooltip'=>'Sets the timer number color',
                'items' => 'start',
                'default_value' => '#ffffff',
                'flex_direction' => 'col',
                'data_property' => 'color',
                'data_dimension_unit_type' => '',
                'data_target' => '.countnum'
            ]), $allowed_html);
            ?>
        </div>
        <div class="w-full flex flex-wrap gap flex-col">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Rounding',
                'key' => 'develux_timer_border_radius',
                'id' => 'develux-timer-border-radius',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 5,
                'tooltip'=>'Allows rounding the corners of the timer number boxes',
                'min' => 0,
                'max' => 10,
                'step' => 1,
                'data_property' => 'border-radius',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countnum'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Number box width',
                'key' => 'develux_timer_width',
                'id' => 'develux-timer-width',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 25,
                'tooltip'=>'Sets the timer number boxes width',
                'min' => 15,
                'max' => 25,
                'step' => 1,
                'data_property' => 'width',
                'data_dimension_unit_type' => '%',
                'data_target' => '.counter-item'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Number box height',
                'key' => 'develux_timer_height',
                'id' => 'develux-timer-height',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 40,
                'tooltip'=>'Sets the timer number boxes height',
                'min' => 20,
                'max' => 60,
                'step' => 1,
                'data_property' => 'height,line-height',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countnum'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Space between boxes',
                'key' => 'develux_timer_gap',
                'id' => 'develux-timer-gap',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 5,
                'tooltip'=>'Sets the space between the number boxes',
                'min' => 0,
                'max' => 15,
                'step' => 1,
                'data_property' => 'gap',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.counter'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Top outer space',
                'key' => 'develux_timer_margin_top',
                'id' => 'develux-timer-margin-top',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => 'px',
                'default_value' => 18,
                'tooltip'=>'Sets the space between the title and number boxes',
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'data_property' => 'margin-top',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countnum'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/color', [
                'post' => $post,
                'legend' => 'Background color',
                'key' => 'develux_timer_background_color',
                'id' => 'develux-timer-background-color',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'default_value' => '#61086d',
                'tooltip'=>'Sets the background color of the number boxes',
                'data_property' => 'background',
                'items' => 'start',
                'data_dimension_unit_type' => '',
                'data_target' => '.countnum'
            ]), $allowed_html);
            ?>
        </div>
        <div class="w-full flex flex-wrap gap flex-col">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Bottom inner space',
                'key' => 'develux_timer_padding_bottom',
                'id' => 'develux-timer-padding-bottom',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => 'px',
                'default_value' => 5,
                'tooltip'=>'Sets the space between the text and the wrapper',
                'min' => 0,
                'max' => 60,
                'step' => 1,
                'data_property' => 'padding-bottom',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.counter'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Horizontal inner space',
                'key' => 'develux_timer_container_padding_x',
                'id' => 'develux-timer-container-padding-x',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Sets the space inside the left and right sides of the numbers container',
                'min' => 0,
                'max' => 40,
                'step' => 1,
                'data_property' => 'padding-left,padding-right',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.counter'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Main width',
                'key' => 'develux_timer_container_width',
                'id' => 'develux-timer-container-width',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => '%',
                'default_value' => 50,
                'tooltip'=>'Sets the width of the container that holds the timer boxes',
                'min' => 50,
                'max' => 100,
                'step' => 1,
                'data_property' => 'width,max-width',
                'data_dimension_unit_type' => '%',
                'data_target' => '.counter'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Main top offset',
                'key' => 'develux_timer_container_vertical_position',
                'id' => 'develux-timer-container-vertical-position',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Sets the vertical location of the number boxes',
                'min' => 0,
                'max' => 10,
                'step' => 1,
                'data_property' => 'top',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.counter'
            ]), $allowed_html);
            ?>
        </div>
        <div class="w-full flex flex-wrap gap flex-col">
            <div>
                <h2>Main wrapper styling</h2>
                <p>Here you can configure the general styling</p>
            </div>
            <?php
            echo wp_kses($renderer->render('tabs/color', [
                'post' => $post,
                'legend' => 'Background color',
                'key' => 'develux_timer_container_background_color',
                'id' => 'develux-timer-container-background-color',
                'class_name' => 'develux-input-js',
                'items' => 'start',
                'default_value' => '#9c75d0',
                'tooltip'=>'Sets the wrapper background color',
                'flex_direction' => 'col',
                'data_property' => '',
                'data_target_color_a' => '',
                'data_dimension_unit_type' => '',
                'data_target' => ''
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Background opacity',
                'key' => 'develux_timer_container_background_a',
                'id' => 'develux-timer-container-background-a',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'placeholder' => '1',
                'default_value' => '1',
                'tooltip'=>'Sets the transparency level of the background color',
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => ''
            ]), $allowed_html);
            ?>
        </div>
        <div class="flex label-style flex-row items-start gap-5 mt-15">
            <?php
            echo wp_kses($renderer->render('general/pro_locked_feature_placeholder', [
                'image_url' => DEVELUXSCT_URL . 'assets/images/pro/timer-background-pro.png',
                'max_width' => '635px',
            ]), $allowed_html);
            ?>
        </div>
        <div class="flex flex-row items-end flex-wrap gap">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Inner space',
                'key' => 'develux_timer_wrapper_padding',
                'id' => 'develux-timer-wrapper-padding',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'col',
                'items' => 'items-start',
                'placeholder' => 'px',
                'default_value' => 15,
                'tooltip'=>'Sets the inner space in the general wrapper',
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'data_property' => 'padding',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countdown-wrapper-js'
            ]), $allowed_html);
            ?>
        </div>
        <div class="w-full flex flex-wrap gap flex-col">
            <?php
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Top offset',
                'key' => 'develux_timer_wrapper_top',
                'id' => 'develux-timer-wrapper-top',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Sets the space between the timer wrapper and the element above',
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'data_property' => 'top',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countdown-wrapper-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Bottom outer space',
                'key' => 'develux_timer_wrapper_margin_bottom',
                'id' => 'develux-timer-wrapper-margin-bottom',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Sets the space between the timer wrapper and the element below',
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'data_property' => 'margin-bottom',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countdown-wrapper-js',
                'container_class' => 'bottom-outer-space-container',
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Rounding',
                'key' => 'develux_timer_wrapper_border_radius',
                'id' => 'develux-timer-wrapper-border-radius',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Allows rounding the corners of the general wrapper',
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'data_property' => 'border-radius',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countdown-wrapper-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/number', [
                'post' => $post,
                'legend' => 'Frame size',
                'key' => 'develux_timer_wrapper_border_width',
                'id' => 'develux-timer-wrapper-border-width',
                'class_name' => 'develux-input-js',
                'items' => 'items-start',
                'flex_direction' => 'col',
                'placeholder' => 'px',
                'default_value' => 0,
                'tooltip'=>'Sets the outline width of the general wrapper',
                'min' => 0,
                'max' => 20,
                'step' => 1,
                'data_property' => 'border-width',
                'data_dimension_unit_type' => 'px',
                'data_target' => '.countdown-wrapper-js'
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/color', [
                'post' => $post,
                'legend' => 'Frame color',
                'key' => 'develux_timer_wrapper_border_color',
                'id' => 'develux-timer-wrapper-border-color',
                'class_name' => 'develux-input-js',
                'items' => 'start',
                'default_value' => '#9c75d0',
                'tooltip'=>'Sets the outline color ',
                'flex_direction' => 'col',
                'data_property' => 'border-color',
                'data_target_color_a' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '.countdown-wrapper-js'
            ]), $allowed_html);

            ?>
        </div>

    </fieldset>




