<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * @var $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
$renderer = $data['renderer'] ?? null;
if (!$post || !$renderer) {
    return;
}
if (!function_exists('wc_get_product')) {
    echo '<p>' . esc_html__('WooCommerce not installed', 'devellux-sales-countdown-timer-builder') . '</p>';
    return;
}
$sale_start = get_post_meta($post->ID, '_sale_price_dates_from', true) ?? 0;
$sale_end = get_post_meta($post->ID, '_sale_price_dates_to', true) ?? 0;
$text_editor_svg = SVG_Generator::generate_text_editor_icons();
$button_svg = SVG_Generator::generate_button_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();
?>
<div>
    <h2>Timer Schedule Settings</h2>
    <p>Choose the type of sale date for the timer.</p>
</div>
<fieldset class="flex w-full flex-wrap flex-col label-block-styles pt-15">
    <div class="w-full flex flex-wrap flex-col gap-30">
        <?php
        echo wp_kses($renderer->render('tabs/checkbox', [
            'post' => $post,
            'legend' => 'Use the default sale price date',
            'key' => 'develux_use_single_product_schedule',
            'description'=>'Choose the sale price date for each product individually',
            'id' => 'develux-use-single-product-schedule',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'row',
            'default_value'=>1
        ]), $allowed_html);
        ?>
    </div>
    <div class="w-full flex flex-wrap flex-col gap-30">
        <div class="mt-15">
        <h2>Unrelated to product timer sale date</h2><p>Use this timer independently of the product settings for any promotional campaigns.<br>
This timer will not use the general discount settings.</p></div>
        <?php
        echo wp_kses($renderer->render('tabs/date', [
            'post' => $post,
            'legend' => 'Timer start date',
            'key' => 'develux_timer_start_date',
            'id' => 'develux-timer-start-date',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'row',
            'items' => 'start',
            'placeholder' => 'date',
            'default_value' => '',
            'tooltip'=>'The sale will start at 00:00:00'
        ]), $allowed_html);
        echo wp_kses($renderer->render('tabs/date', [
            'post' => $post,
            'legend' => 'Timer end date',
            'key' => 'develux_timer_date',
            'id' => 'develux-timer-date',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'row',
            'items' => 'start',
            'placeholder' => 'date',
            'default_value' => '',
            'tooltip'=>'The sale will end at 23:59:59'
        ]), $allowed_html);
        ?>
    </div>
</fieldset>
    <?php
        $sale_start = get_post_meta($post->ID, 'develux_timer_start_date', true);
        $sale_end = get_post_meta($post->ID, 'develux_timer_date', true);

        if ($sale_start) {
            $sale_start = strtotime($sale_start);
        } else {
            $sale_start = time() - (24 * 60 * 60);
        }
        if ($sale_end) {
            if(is_array($sale_end)){
                $sale_end = strtotime($sale_end['end_date'] . ' 23:59:59');
            }else{
                $sale_end = strtotime($sale_end . ' 23:59:59');
            }

        } else {
            $sale_end = time() + (7 * 24 * 60 * 60);
        }

    if ($sale_end && $sale_start <= $sale_end && $sale_start < time()) : ?>
        <?php
        $start_days = floor(($sale_start - time()) / (60 * 60 * 24));
        $remaining_days = floor(($sale_end - time()) / (60 * 60 * 24));

        ?>
        <div id="countdown-timer"
             data-sale-start-in-days="<?php echo esc_attr($start_days); ?>"
             data-sale-end-in-days="<?php echo esc_attr($remaining_days); ?>"
             data-sale-start="<?php echo esc_attr($sale_start); ?>"
             data-sale-end="<?php echo esc_attr($sale_end); ?>"
        >
        </div>
    <?php endif; ?>




