<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * @var $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
$renderer = $data['renderer'] ?? null;
if (!$post || !$renderer) {
    return;
}
if (!function_exists('wc_get_product')) {
    echo '<p>' . esc_html__('WooCommerce not installed', 'devellux-sales-countdown-timer-builder') . '</p>';
    return;
}
$sale_start = get_post_meta($post->ID, '_sale_price_dates_from', true) ?? 0;
$sale_end = get_post_meta($post->ID, '_sale_price_dates_to', true) ?? 0;
$text_editor_svg = SVG_Generator::generate_text_editor_icons();
$button_svg = SVG_Generator::generate_button_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();
?>


    <fieldset class="flex w-full flex-wrap flex-col gap-30 label-block-styles pt-15">

            <?php
            echo wp_kses($renderer->render('tabs/text', [
                'post' => $post,
                'legend' => 'Timer title',
                'key' => 'develux_timer_title',
                'id' => 'develux-timer-title',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'start',
                'placeholder' => 'day',
                'default_value' => 'Timer title',
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '',
                'tooltip'=>'Defines the purpose or occasion behind the sale, helping you identify and manage different promotional events',
                'data_depended_target_value' => ''
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/text', [
                'post' => $post,
                'legend' => 'Day field name',
                'key' => 'develux_timer_day_name',
                'id' => 'develux-timer-day-name',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'start',
                'placeholder' => 'Days',
                'default_value' => 'Days',
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '',
                'tooltip'=>'Defines how the day will be written in this timer',
                'data_depended_target_value' => ''
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/text', [
                'post' => $post,
                'legend' => 'Hour field name',
                'key' => 'develux_timer_hour_name',
                'id' => 'develux-timer-hour-name',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'start',
                'placeholder' => 'Hours',
                'default_value' => 'Hours',
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '',
                'tooltip'=>'Defines how the hour will be written in this timer',
                'data_depended_target_value' => ''
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/text', [
                'post' => $post,
                'legend' => 'Minute field name',
                'key' => 'develux_timer_minute_name',
                'id' => 'develux-timer-minute-name',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'start',
                'placeholder' => 'Min',
                'default_value' => 'Min',
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '',
                'tooltip'=>'Defines how the minutes will be written in this timer',
                'data_depended_target_value' => ''
            ]), $allowed_html);
            echo wp_kses($renderer->render('tabs/text', [
                'post' => $post,
                'legend' => 'Second field name',
                'key' => 'develux_timer_second_name',
                'id' => 'develux-timer-second-name',
                'class_name' => 'develux-input-js',
                'flex_direction' => 'row',
                'items' => 'start',
                'placeholder' => 'Sec',
                'default_value' => 'Sec',
                'data_property' => '',
                'data_dimension_unit_type' => '',
                'data_target' => '',
                'tooltip'=>'Defines how the seconds will be written in this timer',
                'data_depended_target_value' => ''
            ]), $allowed_html);
            ?>

    </fieldset>
    <fieldset class="flex w-full flex-wrap flex-col gap-30 label-block-styles mt-30 pt-15">
        <div>
            <h2>Timer Location Settings</h2>
            <p>Here you can set the locations for the timer.</p>
        </div>
        <?php
        echo wp_kses($renderer->render('tabs/select', [
            'post' => $post,
            'legend' => 'Timer place on product card',
            'key' => 'develux_timer_location',
            'id' => 'develux-timer-location',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'col',
            'items' => 'start',
            'default_value' => 'before_product_title',
            'options' => [
                'before_product_card' => 'Before product card',
                'before_product_title' => 'Before product title',
                'after_product_title' => 'After product title',
            ],
            'tooltip' => 'Sets the place of displaying the timer on the product card',
            'data_property' => '',
            'data_dimension_unit_type' => '',
            'data_target' => ''
        ]), $allowed_html);
        echo wp_kses($renderer->render('tabs/checkbox', [
            'post' => $post,
            'legend' => 'Display on product card',
            'key' => 'develux_timer_display_on_card',
            'id' => 'develux-timer-display-on-card',
            'class_name' => 'develux-input-js',
            'flex_direction' => 'row',
            'tooltip'=>'The selected checkbox enables the timer to be displayed on the product card',
            'default_value' => 1,
            'items' => 'start',
        ]), $allowed_html);

        echo wp_kses($renderer->render('general/pro_locked_feature_placeholder', [
            'image_url' => DEVELUXSCT_URL . 'assets/images/pro/time-product-page-pro.png',
            'max_width' => '635px',
        ]), $allowed_html);
        ?>
    </fieldset>




