<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * @var $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
$renderer = $data['renderer'] ?? null;
if (!$post || !$renderer) {
    return;
}
$allowed_html = $renderer::get_allowed_html();
$sale_start = get_post_meta($post->ID, '_sale_price_dates_from', true) ?? '';
$sale_end = get_post_meta($post->ID, '_sale_price_dates_to', true) ?? '';
$text_editor_svg = SVG_Generator::generate_text_editor_icons();
$button_svg = SVG_Generator::generate_button_icons();
?>
<div id="tab-timer" class="tab-pane w-full">
    <?php
    if (!($sale_start && $sale_end)): ?>
        <p class="w-full p-15">
            <?php esc_html_e('Add Sale price dates first to use countdown timer', 'devellux-sales-countdown-timer-builder'); ?>
        </p>
        <?php
        echo '</div>';
        return;
    endif;
    ?>
    <div class="flex flex-col">
        <?php
        echo wp_kses($renderer->render('tabs/timer_tab_fields',
            ['post' => $post, 'renderer' => $renderer]), $allowed_html);
        ?>
    </div>
</div>


