<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post = $data['post'] ?? null;
if (!$post) {
    return;
}
$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}
$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
if (metadata_exists('post', $post->ID, $key)) {

    $value = get_post_meta($post->ID, $key, true);
    if ($value !== '') {
        $value = esc_attr($value);
    }
} else {
    // Meta key does not exist (user never filled the field)
    $value = $default_value;
}
?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 <?php echo esc_attr($items); ?>">
    <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?>
        <?php if($data_tooltip): ?>
            <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
                <i class="woocommerce-help-tip"></i>
            </span>
        <?php endif; ?>
    </label>
    <div class="w-50 flex flex-row items-center relative">
    <input data-default-value="<?php echo esc_attr($default_value); ?>"
           data-target="<?php echo esc_attr($data_target); ?>"
           data-property="<?php echo esc_attr($data_property); ?>"
           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
           type="text"
           id="<?php echo esc_attr($id); ?>"
           name="<?php echo esc_attr($key); ?>"
           class="<?php echo esc_attr($class_name); ?> widefat"
           value="<?php echo esc_attr($value); ?>">

    </div>
</div>
