<?php

/**
 * @var array $svg_icons
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$button_icons = SVG_Generator::generate_button_icons();
$svg_icons = SVG_Generator::generate_single_edit_menu_icons();
$generate_previewer_icons = SVG_Generator::generate_previewer_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
?>
<ul class="develux-product-tabs">
    <li class="product-tab flex justify-start items-center">
        <a href="#tab-timer-settings" class="tab-js active" data-tab="tab_timer_settings">
            <span class="tab-icon tab-icon-passive"><?php echo wp_kses($svg_icons['properties']['passive'], $allowed); ?></span>
            <span class="tab-icon tab-icon-active"><?php echo wp_kses($svg_icons['properties']['active'], $allowed); ?></span>
            <span class="tab-title"><?php esc_html_e('Timer Settings', 'devellux-sales-countdown-timer-builder'); ?></span>
        </a>
    </li>
    <li class="product-tab flex justify-start items-center">
        <a href="#tab-timer-styles" class="tab-js" data-tab="tab_timer_styles">
            <span class="tab-icon tab-icon-passive"><?php echo wp_kses($button_icons['properties_styling_passive'], $allowed); ?></span>
            <span class="tab-icon tab-icon-active"><?php echo wp_kses($button_icons['properties_styling_active'], $allowed); ?></span>
            <span class="tab-title"><?php esc_html_e('Timer Styling', 'devellux-sales-countdown-timer-builder'); ?></span>
        </a>
    </li>
</ul>
