<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post = $data['post'] ?? null;
if (!$post) {
    return;
}

$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}

$key = $data['key'] ?? '';
$global_key = $key . '_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;


$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$items = $data['items'] ?? 'center';
$flex_direction = $data['flex_direction'] ?? 'col';
$options =$data['options'] ?? [];
if (!$options) {
    return;
}
$default_value = $data['default_value'] ?? '';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
if ($ignore_global_settings) {
    $post_meta_value = get_post_meta($post->ID, $key, true) ?: $default_value;
} else {
    $post_meta_value = $global_value;
}

?>
<div class="flex develux-select-wrapper w-full flex-row items-center gap-5 label-style">
        <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>">
            <?php echo esc_html($legend); ?>
            <?php if($data_tooltip): ?>
                <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
         <i class="woocommerce-help-tip"></i>
    </span>
            <?php endif; ?>
        </label>
    <select data-default-value="<?php echo esc_attr($default_value); ?>"
            data-target="<?php echo esc_attr($data_target); ?>"
            data-property="<?php echo esc_attr($data_property); ?>"
            data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
            id="<?php echo esc_attr($id); ?>"
            name="<?php echo esc_attr($key); ?>"
            class="<?php echo esc_attr($class_name); ?>">
        <?php
        foreach ($options as $value => $display_value): ?>
            <option value="<?php echo esc_attr($value); ?>"
                <?php selected(esc_attr($post_meta_value), esc_attr($value)); ?>>
                <?php echo esc_html($display_value); ?></option>
        <?php endforeach; ?>
    </select>

</div>
