<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
if( !$post ) {
    return;
}
$options = $data['options'] ?? [];
$key = $data['key'] ?? '';
$global_key = $key.'_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;
$allowed = SVG_Generator::get_allowed_svg_elements();

$legend = $data['legend'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$checkbox_val = get_post_meta($post->ID, $key, true);
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
if( $ignore_global_settings ) {
    $value = get_post_meta($post->ID, $key, true);
    if (empty($value) && $default_value) {
        $value = $default_value;
    }
}else{
    $value = $global_value;
}
?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> flex-wrap <?php echo esc_attr($items); ?> gap-5">
    <label><?php echo esc_html($legend); ?></label>
    <?php
    if( $options ): ?>
        <div class="develux-radiobutton-decor flex flex-row items-center">
       <?php foreach($options as $option): ?>

                <label for="<?php echo esc_attr($option['id']) ?? ''; ?>">
                    <input data-default-value="<?php echo esc_attr($default_value); ?>"
                           data-target="<?php echo esc_attr($data_target); ?>"
                           data-property="<?php echo esc_attr($data_property); ?>"
                           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
                           id="<?php echo esc_attr($option['id']) ?? ''; ?>"
                           type="radio"
                           class="<?php echo esc_attr($class_name); ?>"
                           name="<?php echo esc_attr($key); ?>"
                           value="<?php echo esc_attr($option['value']) ?? ''; ?>" <?php checked( $option['value'],  $value ); ?>>
                    <span class="radiobutton-decor-svg-icon"><?php echo wp_kses( $option['label'],$allowed) ?? ''; ?></span>
                </label>

        <?php endforeach; ?>
        </div>
   <?php endif; ?>
</div>

