<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
if( !$post ) {
    return;
}

$svg = SVG_Generator::generate_button_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$info_svg = $svg['info_purple'];

$options = $data['options'] ?? [];
$key = $data['key'] ?? '';
$global_key = $key.'_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;

$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$flex_inner_direction = $data['flex_inner_direction'] ?? 'col';
$checkbox_val = get_post_meta($post->ID, $key, true);
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
if( $ignore_global_settings ){
    $value = get_post_meta($post->ID, $key, true);
    if (empty($value) && $default_value) {
        $value = $default_value;
    }
}else{
    $value = $global_value;
}

?>
<div class="label-style develux-radiobutton flex flex-<?php echo esc_attr($flex_direction); ?> flex-wrap <?php echo esc_attr($items); ?> gap-5">
        <label class="flex justify-between items-center">
            <?php echo esc_html($legend); ?>
            <?php if($data_tooltip): ?>
                <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>"><i class="woocommerce-help-tip"></i></span>
        <?php endif; ?>
        </label>
    <?php
    if( $options ):  ?>
    <div class="flex flex-<?php echo esc_attr($flex_inner_direction); ?> <?php echo esc_attr($items); ?> gap">
  <?php  foreach ($options as $option): ?>

    <div class="flex flex-row gap">
        <input
                data-default-value="<?php echo esc_attr($default_value); ?>"
                data-target="<?php echo esc_attr($data_target); ?>"
                data-property="<?php echo esc_attr($data_property); ?>"
                data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
                id="<?php echo esc_attr($option['id']) ?? ''; ?>"
                type="radio"
                class="<?php echo esc_attr($class_name); ?>"
                name="<?php echo esc_attr($key); ?>"
                value="<?php echo esc_attr($option['value']) ?? ''; ?>"
            <?php checked( esc_attr($option['value']), esc_attr($value) ); ?>>

        <?php
        $description = $option['description'] ?? '';
        $error_message = $option['error_msg'] ?? '';
        $data_tooltip = '';
        $tooltip_icon = '';
        if($description){
            $data_tooltip = $description;
            $tooltip_icon = $info_svg;
        }
        ?>
        <?php if($data_tooltip): ?>
        <label class="develux-radiobutton-label" for="<?php echo esc_attr($option['id']) ?? ''; ?>" >
            <?php
            echo esc_html($option['label']) ?? '';
            echo '<span data-develux-tooltip="'. esc_attr($data_tooltip) . '"><i class="woocommerce-help-tip"></i></span>';
            echo wp_kses('&nbsp; '. $error_message,$allowed);
            ?>
            <?php else: ?>
        <label class="develux-radiobutton-label" for="<?php echo esc_attr($option['id']) ?? ''; ?>" >
            <?php
            echo esc_html($option['label']) ?? '';
            ?>
            <?php endif; ?>
        </label>
    </div>
    <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>
