<?php
if (!defined('ABSPATH')) {
    exit;
}
use DEVELUXSCT\HTMLGenerators\SVG_Generator;



$post = $data['post'] ?? null;
$cpt_post = $data['cpt_post'] ?? $post;
$renderer = $data['renderer'] ?? null;
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();

if (!$post || !$renderer): ?>
    <div class="product-admin-preview flex flex-col justify-start">
        <div class="product-admin-wrapper p-15">
               <span class="flex flex-wrap">
               <?php esc_html__('Currently, no products have any properties.
                You need to add them in the metabox in the Properties tab on the product creation page.
                 Link to documentation', 'devellux-sales-countdown-timer-builder'); ?>
        '       </span>
        </div>
    </div>
    <?php return;
endif;
if (!function_exists('wc_get_product')): ?>
    <div class="product-admin-preview flex flex-col justify-start">
        <div class="product-admin-wrapper p-15">
                <span class="flex flex-wrap">
                    <?php esc_html_e('WooCommerce not installed.', 'devellux-sales-countdown-timer-builder'); ?>
                </span>
        </div>
    </div>';
    <?php return;
endif;

$product = wc_get_product($post->ID);
$generate_previewer_icons = SVG_Generator::generate_previewer_icons();
if (!$product): ?>
    <div class="product-admin-preview flex flex-col justify-start">
        <div class="product-admin-wrapper p-15">
               <span class="flex flex-wrap"><?php esc_html_e('Currently, no products have any properties.
                You need to add them in the metabox in the Properties tab on the product creation page.
                 Link to documentation.', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
        </div>
    </div>
    <?php return;
endif;

?>
<div class="product-admin-preview flex flex-col justify-start">
    <div class="develux-previewer-header flex justify-around items-center">
        <span class="develux-previewer-show-js pointer">
            <span class="show-js hidden"><?php echo wp_kses($generate_previewer_icons['show'], $allowed); ?></span>
            <span class="hide-js"><?php echo wp_kses($generate_previewer_icons['hide'], $allowed); ?></span>
        </span>
        <h3 class="develux-previewer-none-displayable-js">
            <?php esc_html_e('Timer Preview', 'devellux-sales-countdown-timer-builder'); ?>
        </h3>
    </div>
    <div class="relative develux-previewer-none-displayable-js product-admin-wrapper flex flex-col items-center p-15">
        <div class="countdown-timer-location-js countdown-timer-before-item"></div>

        <div class="relative preview-image-container">
            <?php echo wp_kses(get_the_post_thumbnail($post->ID, 'full',''), $allowed_html); ?>
        </div>
        <div class="countdown-timer-location-js countdown-timer-before-title"></div>
        <h3><?php echo wp_kses(get_the_title($post->ID), $allowed_html); ?></h3>
        <div class="countdown-timer-location-js countdown-timer-after-title"></div>
        <p><?php echo wp_kses($product->get_price_html(), $allowed_html); ?></p>
        <div class="mb-15">
            <span class="preview-button"><?php esc_html_e('Buy Now', 'devellux-sales-countdown-timer-builder'); ?></span>
        </div>
    </div>
</div>


