<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * @var array $data
 *
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post = $data['post'] ?? null;
if (!$post) {
    return;
}
$svg = SVG_Generator::generate_button_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$info_svg = $svg['info_purple'];

$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}


$key = $data['key'] ?? '';
$global_key = $key . '_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;

$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$container_class = $data['container_class'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$step = $data['step'] ?? '';
$min = $data['min'] ?? '';
$max = $data['max'] ?? '';
$placeholder = $data['placeholder'] ?? '';
$default_value = $data['default_value'] ?? '';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$depended_target_value = $data['data_depended_target_value'] ?? '';
$items = $data['items'] ?? 'items-start';
if ($ignore_global_settings) {
    $value = esc_attr(get_post_meta($post->ID, $key, true));
    if ($value === '' || $value === null) {
        $value = $default_value;
    }
} else {
    $value = $global_value;
}
$unit_data = $data['unit_data'] ?? [];

?>
<div class="label-style flex flex-row items-center gap-5 <?php echo esc_attr($container_class); ?>">
    <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>">
        <?php echo esc_html($legend); ?>
        <?php if($data_tooltip): ?>
            <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
                <i class="woocommerce-help-tip"></i>
            </span>
        <?php endif; ?>
    </label>
    <div class="w-50 flex flex-row items-center relative">
        <input data-depended-target-value="<?php echo esc_attr($depended_target_value); ?>"
               data-default-value="<?php echo esc_attr($default_value); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               type="number"
               step="<?php echo esc_attr($step); ?>"
               id="<?php echo esc_attr($id); ?>"
               name="<?php echo esc_attr($key); ?>"
               min="<?php echo esc_attr($min); ?>"
               max="<?php echo esc_attr($max); ?>"
               class="<?php echo esc_attr($class_name); ?> widefat rectangle"
               value="<?php echo esc_attr($value); ?>">


    </div>
</div>
