<?php
if (!defined('ABSPATH')) {
    exit;
}
/**
 * @var array $data
 *
 */
$post = $data['post'] ?? null;
if (!$post) {
    return;
}
$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}
$key = $data['key'] ?? '';
$global_key = $key . '_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;


$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';

$items = $data['items'] ?? 'items-center';
if ($ignore_global_settings) {
    $value = get_post_meta($post->ID, $key, true);
} else {
    $value = $global_value;
}
?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 <?php echo esc_attr($items); ?>">
    <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?>
        <?php if($data_tooltip): ?>
            <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
                <i class="woocommerce-help-tip"></i>
            </span>
        <?php endif; ?>
    </label>
    <div class="w-50 flex flex-row items-center relative">

    <input min="2024-12-16"
           type="date" id="<?php echo esc_attr($id); ?>" name="<?php echo esc_attr($key); ?>"
           class="<?php echo esc_attr($class_name); ?> widefat rectangle-2x color-picker"
           value="<?php echo esc_attr($value); ?>">

    </div>
</div>
