<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post = $data['post'] ?? null;
if (!$post) {
    return;
}
$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}
$key = $data['key'] ?? '';
$global_key = $key . '_global';
$global_settings = wp_load_alloptions();
$global_value = $global_settings[$global_key] ?? '';
$ignore_global_settings = $data['ignore_global_settings'] ?? 1;


$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$data_target_color_a = $data['data_target_color_a'] ?? '';
$items = $data['items'] ?? 'items-start';
$default_value = $data['default_value'] ?? '';
if ($ignore_global_settings) {
    $value = esc_attr(get_post_meta($post->ID, $key, true));
} else {
    $value = $global_value;
}
if ($value === '') {
    $value = $default_value;
}
?>
<div class="label-style flex flex-row items-center gap-5 <?php echo esc_attr($items); ?>">
        <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>">
            <?php echo esc_html($legend); ?>
            <?php if($data_tooltip): ?>
                <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
                    <i class="woocommerce-help-tip"></i>
                </span>
            <?php endif; ?>
        </label>
    <div class="flex flex-1 flex-row gap-5 items-center color-picker-wrapper color-picker-wrapper-js">
        <input data-default-value="<?php echo esc_attr($default_value); ?>"
               data-target-color-a="<?php echo esc_attr($data_target_color_a); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               type="color"
               id="<?php echo esc_attr($id); ?>"
               name="<?php echo esc_attr($key); ?>"
               class="<?php echo esc_attr($class_name); ?> widefat color-picker develux-color-picker-js"
               value="<?php echo esc_attr($value); ?>">
        <input data-default-value="<?php echo esc_attr($default_value); ?>"
               data-target-color-a="<?php echo esc_attr($data_target_color_a); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               class="<?php echo esc_attr($class_name); ?> color-hex color-hex-js"
               type="text"
               value="<?php echo esc_attr($value); ?>">

    </div>

</div>
