<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post = $data['post'] ?? null;
if( !$post ) {
    return;
}

$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}
$description = $data['description'] ?? '';
$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$direct_value_checked = $data['data_direct_value_checked'] ?? '';
$direct_value_unchecked = $data['data_direct_value_unchecked'] ?? '';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$value = $data['value'] ?? '';
$default_value = $data['default_value'] ?? '';
$items = $data['items'] ?? 'center';
if ($value === '') {
    $value = get_post_meta($post->ID, $key, true);

    if ($value === '' || $value === null) {
        $value = $default_value;
    }
}
?>
<div class="develux-checkbox-container w-full label-style flex flex-<?php echo esc_attr($flex_direction); ?> items-<?php echo esc_attr($items); ?> gap-5">

   <label class="flex items-center justify-between" for="<?php echo esc_attr($id); ?>">
       <?php echo esc_html($legend); ?>
       <?php if($data_tooltip): ?>
           <span class="flex items-center" data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
       <i class="woocommerce-help-tip"></i>
    </span>
       <?php endif; ?>
   </label>
    <input data-default-value="0" type="hidden" name="<?php echo esc_attr($key); ?>" value="0">
    <input data-target="<?php echo esc_attr($data_target); ?>"
           data-property="<?php echo esc_attr($data_property); ?>"
           data-direct-value-checked="<?php echo esc_attr($direct_value_checked); ?>"
           data-direct-value-unchecked="<?php echo esc_attr($direct_value_unchecked); ?>"
           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
           data-default-value="<?php echo esc_attr($default_value); ?>"
           type="checkbox"
           name="<?php echo esc_attr($key); ?>"
           class="<?php echo esc_attr($class_name); ?> develux-checkbox"
           id="<?php echo esc_attr($id); ?>"
           value="1" <?php checked( 1, $value, true );?>/>
    <?php if($description):?>
    <span>&nbsp;<?php echo esc_attr($description); ?></span>
    <?php endif; ?>

</div>