<?php
if (!defined('ABSPATH')) {
    exit;
}

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

/**
 * @var array $data
 */
$renderer = $data["renderer"];
$timer_id = $data['timer_id'];
if (!$timer_id): ?>
    <p><?php esc_html_e('No timer ID specified. Nothing to edit.', 'devellux-sales-countdown-timer-builder'); ?></p>
    <?php return;
endif;

$post = $data['post'];
$args = [
    'post_type' => 'product',
    'post_status' => 'publish',
    'posts_per_page' => 1,
];

$query = new WP_Query($args);
$bind_obj = $query->post;
$current_title = get_the_title($timer_id);
$text_editor_svg = SVG_Generator::generate_text_editor_icons();
$button_svg = SVG_Generator::generate_button_icons();
$gradient_type_svg = SVG_Generator::generate_gradient_types_icons();
$positioning_icons = SVG_Generator::generate_positioning_icons();
$border_icons = SVG_Generator::generate_border_icons();
$pseudo_icons = SVG_Generator::generate_pseudo_element_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();
?>
<div class="product-tab-content product-tab-content-js develux-label-constructor-working-place flex flex-wrap gap">

    <div class="mt-14 w-full p-10">

        <div id="develux_timer_settings" class="flex flex-col develux-library-tab-component active">
            <h2>Timer Settings</h2>
            <p>Here you can set the titles for the timer.</p>
            <div class="label-style flex flex-row pt-15 pb-30 w-full">
                <input data-default-value="<?php echo esc_attr($timer_id); ?>"
                       type="hidden" name="develux_current_timer_id"
                       id="develux_current_timer_id" value="<?php echo esc_attr($timer_id); ?>">
                <div class="w-full label-style flex flex-row gap-5">
                    <label for="develux_timer_new_title"><?php esc_html_e('Timer name', 'devellux-sales-countdown-timer-builder'); ?>
                        <span data-develux-tooltip="Defines the name you assign to identify it among your created timers">
                            <i class="woocommerce-help-tip"></i>
                        </span>
                    </label>
                    <input type="text" class="w-50"
                           id="develux_label_new_title"
                           value="<?php echo esc_attr($current_title); ?>"
                           name="develux_timer_new_title" placeholder="title">
                </div>
            </div>
            <?php
            echo wp_kses($renderer->render('general/hidden', [
                'key' => 'develux_timer_id',
                'id' => 'develux-timer-id',
                'timer_id' => $timer_id,
                'class_name' => 'develux-timer-input-js',
            ]), $allowed_html);
            ?>
            <?php
            echo wp_kses($renderer->render('tabs/timer_tab_data_fields', ['post' => $post, 'renderer' => $renderer]), $allowed_html);
            ?>
        </div>
        <div id="develux_timer_schedule" class="flex flex-col develux-library-tab-component">
            <?php
            echo wp_kses($renderer->render('tabs/timer_tab_schedule', ['post' => $post, 'renderer' => $renderer]), $allowed_html);
            ?>
        </div>
        <div id="develux_timer_styles" class="flex flex-col develux-library-tab-component">
            <?php
            echo wp_kses($renderer->render('tabs/timer_tab_styles_fields', ['post' => $post, 'renderer' => $renderer]), $allowed_html);
            ?>

        </div>


        <button class="develux-button add-button save-button m-30-auto" type="submit">
            <?php esc_html_e('Save', 'devellux-sales-countdown-timer-builder'); ?>
        </button>
    </div>

</div>
