<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$post = $data['post'] ?? null;
$renderer = $data['renderer'] ?? null;
if (!$post || !$renderer) {
    return;
}

$allowed_html = $renderer::get_allowed_html();
?>
<div class="develux-wrapper-bulk-editor" id="develux-label-main-id" data-label-id="<?php echo esc_attr($timer_id);?>">
    <div class="develux-wrapper-taxonomies">
        <div class="develux-categories-box">

            <p class="develux-bulk-action-title">WooCommerce Categories</p>
            <div class="develux-woo-cat-list">

                <div class="develux-cat-row develux-cat-row-header">
                    <div class="develux-items-line">
                        <input type="checkbox" id="develux-check-all-cats">
                    </div>
                    <div>
                        <p>Image</p>
                    </div>
                    <div>
                        <p>Category Name</p>
                    </div>
                    <div>
                        <p>Quantity of products</p>
                    </div>
                </div>
                <div class="taxonomy-list-box">
                    <?php foreach($cat_list as $cat_item):?>
                    <div class="develux-cat-row">
                        <div>
                            <input <?php if($cat_item->chacked_status == "true"){echo "checked";} ?>
                                    type="checkbox"
                                    id="develux-c-item-<?php echo esc_attr($cat_item->cat_ID); ?>"
                                    name="develux-woo-cat"
                                    value="<?php echo esc_attr($cat_item->cat_ID); ?>"
                                    class="develux-cat-checkbox">
                        </div>
                        <div>
                            <label  class="c-pointer" for="develux-c-item-<?php echo esc_attr($cat_item->cat_ID); ?>">
                                <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
                                <img width="50" height="50" class="develux-cat-image" src="<?php echo esc_attr($cat_item->cat_img); ?>" alt="cat-image">
                            </label>
                        </div>
                        <div>
                            <p>
                                <label  class="c-pointer" for="develux-c-item-<?php echo esc_attr($cat_item->cat_ID); ?>">
                                    <?php echo esc_html($cat_item->name); ?>
                                </label>
                            </p>
                        </div>
                        <div>
                            <p><?php echo esc_html($cat_item->count); ?></p>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
        <div class="develux-tags-box">
            <p class="develux-bulk-action-title">WooCommerce Tags</p>
            <div class="develux-woo-tag-list">

                <div class="develux-tag-row develux-tag-row-header">
                    <div class="develux-items-line">
                        <input type="checkbox" id="develux-check-all-tags">
                    </div>
                    <div>
                        <p>Tag Name</p>
                    </div>
                    <div>
                        <p>Quantity of products</p>
                    </div>
                </div>

                <div class="taxonomy-list-box">
                    <?php foreach($tag_list as $tag_item):?>
                        <div class="develux-tag-row">
                            <div>
                                <input <?php if($tag_item->chacked_status == "true"){echo "checked";} ?> type="checkbox" id="develux-t-item-<?php echo esc_attr($tag_item->cat_ID); ?>" name="develux-woo-tag" value="<?php echo esc_attr($tag_item->cat_ID); ?>" class="develux-tag-checkbox">
                            </div>
                            <div>
                                <p>
                                    <label  class="c-pointer" for="develux-t-item-<?php echo esc_attr($tag_item->cat_ID); ?>">
                                        <?php echo esc_html($tag_item->name); ?>
                                    </label>
                                </p>
                            </div>
                            <div>
                                <p><?php echo esc_html($tag_item->count); ?></p>
                            </div>
                        </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </div>
    <div class="hr"></div>
    <div class="develux-wrapper-search-product">
        <div class="develux-include-box">
            <?php
            echo wp_kses($renderer->render('general/pro_locked_feature_placeholder', [
                'image_url' => DEVELUXSCT_URL . 'assets/images/pro/timer-include-pro.png',
            ]), $allowed_html);
            ?>
        </div>




        <div class="develux-exclude-box">
            <?php
            echo wp_kses($renderer->render('general/pro_locked_feature_placeholder', [
                'image_url' => DEVELUXSCT_URL . 'assets/images/pro/timer-exclude-pro.png',
            ]), $allowed_html);
            ?>
        </div>
    </div>
</div>