<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * @var array $data
 */


use DEVELUXSCT\HTMLGenerators\CountdownTimerGenerator;
use DEVELUXSCT\HTMLGenerators\TemplateRenderer;

$post_type = $data['post_type'];
$posts_per_page = $data['posts_per_page'];
$renderer = $data['renderer'];
if (!$renderer) {
    return;
}
$query = new \WP_Query([
    'post_type' => $post_type,
    'posts_per_page' => $posts_per_page
]);
$allowed_html = $renderer::get_allowed_html();
$nonce = wp_create_nonce('timer_editor_access');
echo '<input type="hidden" id="timer_editor_nonce" name="timer_editor_nonce" value="' . esc_attr($nonce) . '" />';
?>

    <?php
    if ($query->have_posts()):?>
    <div class="develux-timer-items-wrapper">
        <div class="develux-timer-items w-full">
            <div class="develux-timer-items-caption w-full flex justify-between items-center">
                <span class="develux-timer-items-caption-title"><?php esc_html_e('Name','devellux-sales-countdown-timer-builder'); ?></span>
                <span class="develux-timer-items-caption-title"><?php esc_html_e('Action','devellux-sales-countdown-timer-builder'); ?></span>
            </div>
            <div class="develux-timer-items-table">
                <?php
                while ($query->have_posts()):
                    $query->the_post();
                    $post_id = get_the_ID();
                    $title = get_the_title();
                    ?>
                    <div class="p-15 develux-custom-block-item flex items-center justify-between" data-post-id="<?php echo esc_attr($post_id); ?>">
                        <a href="<?php echo esc_url(admin_url('admin.php?page=develux-timer-builder&nonce=' . $nonce . '&timer_id=' . $post_id)); ?>" class="develux-custom-block-item-title  flex justify-center items-center"><?php echo esc_html($title); ?></a>
                        <button data-post-id="<?php echo esc_attr($post_id); ?>" class="develux-delete-custom-block-btn develux-delete-label-permanently-js">
                            <?php esc_html_e('Delete','devellux-sales-countdown-timer-builder'); ?>
                        </button>
                    </div>
                <?php
                endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
    </div>

    <?php endif; ?>

