<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * @var array $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;
use DEVELUXSCT\Options\Default_Post_Query_Data;
use DEVELUXSCT\Options\Help_Center;
use DEVELUXSCT\Taxonomies\Categories;
use DEVELUXSCT\Taxonomies\Tags;
use DEVELUXSCT\BulkManager\Bulk;

if(!isset($_GET['nonce'])){
    return;
}
if(!isset($_GET['timer_id'])){
    return;
}
$nonce = sanitize_text_field(wp_unslash($_GET['nonce']));
if( !wp_verify_nonce($nonce, 'timer_editor_access')) {
    return;
}


$renderer = $data["renderer"];
$timer_id = absint(sanitize_text_field(wp_unslash($_GET['timer_id']))) ?? '';
$post = get_post($timer_id);
if (!$timer_id) {
    echo "<p class='mt-15 p-15'>No ID specified. Nothing to edit.</p>";
    return;
}
try {
    $bind_obj = Default_Post_Query_Data::get_default_single_product();
} catch (Exception $e) {
    echo "<p class='mt-15 p-15'>No Product found. Nothing to edit.</p>";
    return;
}
$svg_tabs_icons = SVG_Generator::generate_single_edit_menu_icons();
$allowed = SVG_Generator::get_allowed_svg_elements();
$allowed_html = $renderer::get_allowed_html();
?>
<div class="develux">
<div class="develux-timer-builder-tabs-switcher flex flex-row justify-start mr-15 mt-15">
    <div class="pl-15 tab-develux-timer-builder-btn tab-develux-timer-builder-btn-js active" data-tab="develux_timer_settings">
        <span class="w-full flex flex-row gap items-center">
            <?php esc_html_e('Timer Settings', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
    </div>
    <div class="pl-15 tab-develux-timer-builder-btn tab-develux-timer-builder-btn-js" data-tab="develux_timer_schedule">
        <span class="w-full flex flex-row gap items-center">
            <?php esc_html_e('Timer Schedule', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
    </div>
    <div class="pl-15 tab-develux-timer-builder-btn tab-develux-timer-builder-btn-js" data-tab="develux_timer_styles">
        <span class="w-full flex flex-row gap items-center">
            <?php esc_html_e('Timer Styles', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
    </div>
    <div class="pl-15 tab-develux-timer-builder-btn tab-develux-timer-builder-btn-js" data-tab="relations">
        <span class="w-full flex flex-row gap items-center">
           <?php esc_html_e('Timer bulk manager', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
    </div>
    <div class="pl-15 tab-develux-timer-builder-btn tab-develux-timer-builder-btn-js" data-tab="develux_timer_help_center">
        <span class="w-full flex flex-row gap items-center">
           <?php esc_html_e('Help Center', 'devellux-sales-countdown-timer-builder'); ?>
        </span>
    </div>
</div>
<form id="develux-timer-builder" method="post"
      class="relative mr-15 flex flex-row flex-wrap develux-timer-builder develux-timer-builder-js">
<div id="develux_timer_save_success_msg" class="develux-success-save-msg"></div>
    <div id="develux_label_previewer" class="w-full flex">
        <?php
        echo wp_kses($renderer->render('general/timer_editor/timer_total_form',
            ['post' => $post, 'timer_id' => $timer_id, 'renderer' => $renderer]), $allowed_html);
        echo wp_kses($renderer->render('tabs/preview',
            ['post' => $bind_obj, 'renderer' => $renderer]), $allowed_html);
        ?>
    </div>
    <div id="develux_label_relations" class="w-full p-15 hidden">
        <h2><?php esc_html_e('Timer Relations', 'devellux-sales-countdown-timer-builder'); ?></h2>
        <?php echo wp_kses($renderer->render('general/timer_editor/timer_relations', [
            'post' => $post,
            'timer_id' => $timer_id,
            'renderer' => $renderer,
            'cat_list' => Categories::get_categories_list($timer_id),
            'tag_list' => Tags::get_tags_list($timer_id),
            'included_product_list' => Bulk::get_included_products($timer_id),
            'excluded_product_list' => Bulk::get_excluded_products($timer_id),
        ]), $allowed_html); ?>
    </div>
    <div id="develux_timer_help_center" class="w-full p-15 hidden">
        <?php echo wp_kses(Help_Center::get_html(), $allowed_html); ?>
    </div>

</form>
</div>