<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 */
$form_id = $data['form_id'];
$id = $data['id'];
$name = $data['name'];
$label = $data['label'];
$post_type = $data['post_type'];
?>
<form class="develux-create-timer-form flex flex-col justify-start flex-wrap items-start gap-5 pr-15 mt-30"
      id="<?php echo esc_attr($form_id); ?>"
      method="post" autocomplete="off"
      data-url="<?php echo esc_url(admin_url('admin.php?page=develux-timer-builder&timer_id=')); ?>">
    <b>Add new timer</b>
    <label for="<?php echo esc_attr($id); ?>"><?php echo esc_attr($label); ?></label>
    <input type="text"  class="w-full"
           id="<?php echo esc_attr($id); ?>"
           placeholder="<?php echo esc_attr($label); ?>"
           name="<?php echo esc_attr($name); ?>" required>
    <input type="hidden" id="post-type" name="post_type" value="<?php echo esc_attr($post_type); ?>">
    <span>Create new timer.</span>
    <button type="submit" class="develux-wc-button ml-0 mt-15"><?php esc_html_e('Create New Timer', 'devellux-sales-countdown-timer-builder'); ?></button>
</form>
