<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */

$post_id = $data['post_id'];
$legend = $data['legend'] ?? '';
$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
$value = get_post_meta($post_id, $key, true);
if(!$value){
    $value = $default_value;
}
?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 <?php echo esc_attr($items); ?>">
    <label for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?></label>
    <input data-target="<?php echo esc_attr($data_target); ?>"
           data-property="<?php echo esc_attr($data_property); ?>"
           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
           type="text"
           id="<?php echo esc_attr($id); ?>"
           name="<?php echo esc_attr($key); ?>"
           class="<?php echo esc_attr($class_name); ?> widefat"
           value="<?php echo esc_attr($value); ?>">
</div>
