<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post_id = $data['post_id'] ?? '';
$legend = $data['legend'] ?? '';
$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$items = $data['items'] ?? 'center';
$flex_direction = $data['flex_direction'] ?? 'col';
$options = $data['options'] ?? [];
if (!$options) {
    return;
}
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$default_value = $data['default_value'] ?? '';
if ($post_id) {
    $post_meta_value = get_post_meta($post_id, $key, true) ?? $default_value;
} else {
    $post_meta_value = $data['value'] ?? $default_value;
}


?>
<div class="flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 items-<?php echo esc_attr($items); ?> label-style">
    <label for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?></label>
    <select data-default-value="<?php echo esc_attr($default_value); ?>"
            data-target="<?php echo esc_attr($data_target); ?>"
            data-property="<?php echo esc_attr($data_property); ?>"
            data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
            id="<?php echo esc_attr($id); ?>"
            name="<?php echo esc_attr($key); ?>"
            class="<?php echo esc_attr($class_name); ?>">
        <?php
        foreach ($options as $value => $display_value): ?>
            <option value="<?php echo esc_attr($value); ?>" <?php selected(esc_attr($post_meta_value), esc_attr($value)); ?>><?php echo esc_html($display_value); ?></option>
        <?php endforeach; ?>
    </select>
</div>
