<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var $product_id
 */
$product = get_posts([
    'post_type' => 'product',
    'posts_per_page' => 1,
    'include' => $product_id
]);

?>
<div class="develux-found-product-wrapper develux-included-prod-to-list"
     data-product-id="<?php echo esc_attr($product[0]->ID); ?>">
    <div class="develux-found-product-item" data-product-id="<?php echo esc_attr($product[0]->ID); ?>">
        <?php if (get_the_post_thumbnail_url($product[0]->ID)): ?>
            <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
            <img width="40" height="40" src="<?php echo esc_url(get_the_post_thumbnail_url($product[0]->ID)); ?>"
                 alt="product image">
        <?php else: ?>
            <?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
            <img width="40" height="40"
                 src="<?php echo esc_url(plugin_dir_url(__FILE__) .
                     '../../../assets/images/helpers/woocommerce-placeholder.png');
                 ?>"
                 alt="product image">
        <?php endif; ?>
        <?php echo esc_html($product[0]->post_title); ?>
    </div>
    <div class="develux-add-product-to-include">
        <button class="develux-action-remove-product-from-included"
                data-product-id="<?php echo esc_attr($product[0]->ID); ?>">
            <?php esc_html_e('Remove', 'devellux-sales-countdown-timer-builder'); ?>
        </button>
    </div>
</div>