<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var $search
 * @var $all_products_arr
 * @var $action_type
 */
$results = get_posts([
    'post_type' => 'product',
    'posts_per_page' => 25,
    's' => $search,
]);

if (!empty($results) || $results != 0) {
    foreach ($results as $product):?>
        <div class="develux-found-product-wrapper <?php
        if (array_search($product->ID, $all_products_arr) !== false) {
            echo 'develux-included-product-box';
        } ?>">
            <div class="develux-found-product-item" data-product-id="<?php echo esc_attr($product->ID); ?>">
                <?php if (get_the_post_thumbnail_url($product->ID)): ?>
                    <img width="40" height="40"
                         src="<?php echo esc_url(get_the_post_thumbnail_url($product->ID)); ?>" alt="product image">
                <?php else: ?>
                    <img width="40" height="40"
                         src="<?php echo esc_url(plugin_dir_url(__FILE__) .
                             '../../../assets/images/helpers/woocommerce-placeholder.png'); ?>" alt="product image">
                <?php endif; ?>
                <?php echo esc_html($product->post_title); ?>
            </div>
            <div class="develux-add-product-to-include">

                <button class="<?php if ($action_type == 'include') {
                    echo 'develux-action-add-product-to-include';
                } else {
                    echo 'develux-action-add-product-to-exclude';
                } ?>
                <?php if (array_search($product->ID, $all_products_arr) !== false) {
                    echo 'develux-hide-dynamic-item';
                } ?>" data-product-id="<?php echo esc_attr($product->ID); ?>">
                    <?php esc_html_e('Add product', 'devellux-sales-countdown-timer-builder'); ?>
                </button>

                <div class="develux-included-product <?php if (array_search($product->ID, $all_products_arr) === false) {
                    echo 'develux-hide-dynamic-item';
                } ?>">
                    <?php esc_html_e('Included', 'devellux-sales-countdown-timer-builder'); ?>
                </div>

            </div>
        </div>
    <?php endforeach;
} else {
    echo 'No result';
}
?>