<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * @var array $data
 */

use DEVELUXSCT\HTMLGenerators\SVG_Generator;

$post_id = $data['post_id'] ?? '';
$options = $data['options'] ?? [];
$key = $data['key'] ?? '';
$legend = $data['legend'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
$value = $data['value'] ?? $default_value;
if ($post_id) {
    $value = get_post_meta($post_id, $key, true);
    if (empty($value) && $default_value) {
        $value = $default_value;
    }
}
$allowed = SVG_Generator::get_allowed_svg_elements();

?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> flex-wrap <?php echo esc_attr($items); ?> gap-5">
    <label><?php echo esc_html($legend); ?></label>
    <?php
    if ($options): ?>
        <div class="develux-radiobutton-decor flex flex-row items-center">
            <?php foreach ($options as $option): ?>

                <label for="<?php echo esc_attr($option['id']) ?? ''; ?>">
                    <input data-default-value="<?php echo esc_attr($default_value); ?>"
                           data-target="<?php echo esc_attr($data_target); ?>"
                           data-property="<?php echo esc_attr($data_property); ?>"
                           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
                           id="<?php echo esc_attr($option['id']) ?? ''; ?>"
                           type="radio"
                           class="<?php echo esc_attr($class_name); ?>"
                           name="<?php echo esc_attr($key); ?>"
                           value="<?php echo esc_attr($option['value']) ?? ''; ?>"
                        <?php checked(esc_attr($option['value']), esc_attr($value)); ?>>
                    <span class="radiobutton-decor-svg-icon">
                        <?php echo wp_kses($option['label'], $allowed) ?? ''; ?>
                    </span>
                </label>

            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

