<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post_id = $data['post_id'] ?? '';
$options = $data['options'] ?? [];
$key = $data['key'] ?? '';
$gap = $data['gap'] ?? 'gap';
$inner_gap = $data['inner_gap'] ?? 'gap-5';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$flex_inner_direction = $data['flex_inner_direction'] ?? 'row';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$default_value = $data['default_value'] ?? '';
$value = $data['value'] ?? $default_value;
if( $post_id ){
    $value = get_post_meta($post_id, $key, true);
    if( $value === '' || $value === null ) {
        $value = $default_value;
    }
}

?>
<div class="label-style <?php echo esc_attr($gap); ?> flex flex-<?php echo esc_attr($flex_direction); ?> flex-wrap <?php echo esc_attr($items); ?> ">
    <?php
    if( $options ):
    foreach($options as $option): ?>
    <div class="flex flex-<?php echo esc_attr($flex_inner_direction); ?> <?php echo esc_attr($items); ?> <?php echo esc_attr($inner_gap); ?>">
        <label for="<?php echo esc_attr($option['id']) ?? ''; ?>"><?php echo esc_html($option['label']) ?? ''; ?></label>
        <input data-default-value="<?php echo esc_attr($default_value); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               id="<?php echo esc_attr($option['id']) ?? ''; ?>"
               type="radio"
               class="<?php echo esc_attr($class_name); ?>"
               name="<?php echo esc_attr($key); ?>"
               value="<?php echo esc_attr($option['value']) ?? ''; ?>"
            <?php checked( esc_attr($option['value']), esc_attr($value) ); ?>>
    </div>
    <?php
    endforeach;
    endif;
    ?>
</div>
