<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * @var array $data
 * $data['image_url'] — URL Image Placeholder
 * $data['buy_link'] — Pro plugin link
 * $data['max_width'] - default 100%
 */

$image_url = esc_url( $data['image_url'] ?? '' );
$buy_link  = esc_url( $data['buy_link'] ?? 'https://codecanyon.net/item/sales-countdown-timer-builder/59002596' );
$max_width  = esc_attr( $data['max_width'] ?? '100%' );
?>

<div class="devellux-pro-feature-placeholder" style="max-width: <?php echo esc_attr($max_width); ?>;">
    <img src="<?php echo esc_url($image_url); ?>" alt="<?php esc_html_e('PRO Feature', 'devellux-sales-countdown-timer-builder'); ?>" class="devellux-pro-feature-image" />

    <div class="devellux-pro-feature-overlay">
        <a href="<?php echo esc_url($buy_link); ?>" target="_blank" class="devellux-pro-feature-button">
            <img class="devellux-pro-feature-icon" src="<?php echo esc_url(DEVELUXSCT_URL . 'assets/images/icons/file.svg'); ?>">
            <div class="devellux-pro-feature-text">
                <?php esc_html_e('Buy PRO', 'devellux-sales-countdown-timer-builder'); ?>
            </div>
        </a>
    </div>
</div>