<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */

$legend = $data['legend'] ?? '';
$tooltip = $data['tooltip'] ?? '';
$data_tooltip = '';
if ($tooltip) {
    $data_tooltip =  $tooltip;
}

$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$step = $data['step'] ?? '';
$min = $data['min'] ?? '';
$max = $data['max'] ?? '';
$placeholder = $data['placeholder'] ?? '';

$default_value = $data['default_value'] ?? '';
$data_property = $data['data_property'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$depended_target_value = $data['data_depended_target_value'] ?? '';
$items = $data['items'] ?? 'items-center';
$post_id = $data['post_id'] ?? '';
$value = $data['value'] ?? $default_value;
if ($post_id) {
    $value = get_post_meta($post_id, $key, true);
    if ($value === '' || $value === null) {
        $value = $default_value;
    }
}


?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 <?php echo esc_attr($items); ?>">
    <label for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?></label>
    <input data-depended-target-value="<?php echo esc_attr($depended_target_value); ?>"
           data-default-value="<?php echo esc_attr($default_value); ?>"
           data-target="<?php echo esc_attr($data_target); ?>"
           data-property="<?php echo esc_attr($data_property); ?>"
           data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
           type="number"
           step="<?php echo esc_attr($step); ?>"
           min="<?php echo esc_attr($min); ?>"
           max="<?php echo esc_attr($max); ?>"
           id="<?php echo esc_attr($id); ?>"
           name="<?php echo esc_attr($key); ?>"
           placeholder="<?php echo esc_attr($placeholder); ?>"
           class="<?php echo esc_attr($class_name); ?> widefat rectangle"
           value="<?php echo esc_attr($value); ?>">
    <?php if($data_tooltip): ?>
        <span data-develux-tooltip="<?php echo esc_attr($data_tooltip); ?>">
                <i class="woocommerce-help-tip"></i>
            </span>
    <?php endif; ?>
</div>
