<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
/**
 * @var array $data
 *
 */
$post_id = $data['post_id'] ?? '';
$legend = $data['legend'] ?? '';
$key = $data['key'] ?? '';
$id = $data['id'] ?? '';
$class_name = $data['class_name'] ?? '';
$flex_direction = $data['flex_direction'] ?? 'col';
$data_property = $data['data_property'] ?? '';
$default_value = $data['default_value'] ?? '';
$data_dimension_unit_type = $data['data_dimension_unit_type'] ?? '';
$data_target = $data['data_target'] ?? '';
$items = $data['items'] ?? 'items-center';
$data_target_color_a = $data['data_target_color_a'] ?? '';
$value = $data['value'] ?? '';
if ($post_id) {
    $value = get_post_meta($post_id, $key, true) ?: $default_value;
}

?>
<div class="label-style flex flex-<?php echo esc_attr($flex_direction); ?> gap-5 <?php echo esc_attr($items); ?>">
    <label for="<?php echo esc_attr($id); ?>"><?php echo esc_html($legend); ?></label>
    <div class="flex flex-row gap-5 color-picker-wrapper color-picker-wrapper-js">
        <input data-target-color-a="<?php echo esc_attr($data_target_color_a); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               class="<?php echo esc_attr($class_name); ?> color-hex color-hex-js"
               type="text"
               value="<?php echo esc_attr($value); ?>">
        <input data-target-color-a="<?php echo esc_attr($data_target_color_a); ?>"
               data-target="<?php echo esc_attr($data_target); ?>"
               data-property="<?php echo esc_attr($data_property); ?>"
               data-unit="<?php echo esc_attr($data_dimension_unit_type); ?>"
               type="color"
               id="<?php echo esc_attr($id); ?>"
               name="<?php echo esc_attr($key); ?>"
               class="<?php echo esc_attr($class_name); ?> widefat color-picker develux-color-picker-js"
               value="<?php echo esc_attr($value); ?>">
    </div>
</div>
