<?php
/**
 * Plugin Name: Devellux Sales Countdown Timer Builder
 * Plugin URI: https://develux.com/documentation-for-plugins/sale-countdown-timer-builder/
 * Description: This plugin is designed to customize the appearance of a product countdown timer with a unique design.
 * Author: Develux team
 * Author URI: https://www.develux.com
 * Developer: Develux team
 * Developer URI: https://www.develux.com
 * Version: 1.0.1
 * Text Domain: devellux-sales-countdown-timer-builder
 * Version: 1.0.1
 * Requires PHP: 7.4
 * Requires at least: 5.0
 * WC requires at least: 7.9
 * WC tested up to: 9.3.3
 * Tested up to: 6.7
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

use DEVELUXSCT\Core\Admin_Notice;
use DEVELUXSCT\Core\CoreRunner;
use DEVELUXSCT\Options\CPT_Default_Instances;
use DEVELUXSCT\Product_Card_Customizer_Facade;

if (!defined('ABSPATH')) {
    exit;
}

require_once ABSPATH . 'wp-admin/includes/plugin.php';
require_once __DIR__ . '/vendor/autoload.php';

add_action('plugins_loaded', function () {
    if (!class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
    }
});

define('DEVELUXSCT_DWPC_PATH', plugin_dir_path(__FILE__));
define('DEVELUXSCT_URL', plugin_dir_url(__FILE__));
define('DEVELUXSCT_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('DEVELUXSCT_DOMAIN', 'devellux-sales-countdown-timer-builder');
define('DEVELUXSCT_MIN_WP_VERSION', '6.0');
define('DEVELUXSCT_MIN_WC_VERSION', '8.0');

global $wp_version;
if (!class_exists('WooCommerce')) {

    define('DEVELUXSCT_WOOCOMMERCE_MISSING', true);
    define('DEVELUXSCT_WOOCOMMERCE_VERSION_OUTDATED', false);

} else {

    $wc_version = get_option('woocommerce_version', '0');
    define('DEVELUXSCT_WOOCOMMERCE_MISSING', false);
    define('DEVELUXSCT_WOOCOMMERCE_VERSION_OUTDATED', version_compare($wc_version, DEVELUXSCT_MIN_WC_VERSION, '<'));

}

define('DEVELUXSCT_WP_VERSION_OUTDATED', version_compare($wp_version, DEVELUXSCT_MIN_WP_VERSION, '<'));

$plugin_path = trailingslashit(WP_PLUGIN_DIR) . 'woocommerce/woocommerce.php';

add_action('before_woocommerce_init', function () {

    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }

});

if (in_array($plugin_path, wp_get_active_and_valid_plugins(), true)) {

    CoreRunner::run();
    new Product_Card_Customizer_Facade();
    register_activation_hook(__FILE__, static function () {
        new CPT_Default_Instances();
    });

} else {
    new Admin_Notice();
}