import {numberDisplay} from './numberDisplay';
import $ from "jquery";


const interval = setInterval(() => updateTimerAdmin(), 1000);
export const updateTimerAdmin = () => {
    const timerElement = document.getElementById('countdown-timer');
    if (!timerElement) return;

    const saleEndTimestamp = parseInt(timerElement.dataset.saleEnd) * 1000; // saleEnd in milliseconds
    const difference = saleEndTimestamp - Date.now();
    const expired = difference < 0;
    const timerDisplayAnimation = $('input[name="develux_timer_display_animation"]');
    // Calculate each time component directly from `difference`
    const days = Math.floor(difference / (1000 * 60 * 60 * 24));
    const hours = Math.floor((difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    const minutes = Math.floor((difference % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((difference % (1000 * 60)) / 1000);

    // Update the display with correct values
    if( timerDisplayAnimation.is(':checked') ){
        numberDisplay(days, "#blockDays", expired, hours === 0 && minutes === 0 && seconds === 0);
        numberDisplay(hours, "#blockHours", expired, minutes === 0 && seconds === 0);
        numberDisplay(minutes, "#blockMinutes", expired, seconds === 0);
        numberDisplay(seconds, "#blockSeconds", expired, true);
    }else{
        numberDisplay(days, "#blockDays", expired, false);
        numberDisplay(hours, "#blockHours", expired, false);
        numberDisplay(minutes, "#blockMinutes", expired, false);
        numberDisplay(seconds, "#blockSeconds", expired, false);
    }


    if (expired) {
        clearInterval(interval);
        document.querySelector(".counter").remove();
    }
};
