import * as $ from 'jquery';
import {updateGlobalTimerPreview} from "./global-timer/updateGlobalTimerPreview";
import {updateMetaboxTimerPreview} from "./timer/updateMetaboxTimerPreview";

/**
 * handle media uploads and icon removal.
 *
 * @param {Object} options
 * @param {string} options.uploadButtonSelector - The selector for the upload button.
 * @param {string} options.imageContainerSelector - The selector for the image container (where the uploaded image will be shown).
 * @param {string} options.inputIdFieldSelector - The selector for the hidden input field that stores the image ID.
 * @param {string} options.inputUrlFieldSelector - The selector for the hidden input field that stores the image URL.
 * @param {string} options.removeButtonSelector - The selector for the remove icon button.
 */
export const handleIconUpload = (options)=>{
    const {
        uploadButtonSelector,
        imageContainerSelector,
        inputIdFieldSelector,
        inputUrlFieldSelector,
        removeButtonSelector
    } = options;

    // Handle file upload
    $(document).on('click', uploadButtonSelector, function (e) {
        e.preventDefault();


        const $imageBox = $(imageContainerSelector);
        const mediaFrame = wp.media({
            title: 'Select or Upload an Icon',
            button: {
                text: 'Use this icon',
            },
            multiple: false
        });

        mediaFrame.open();

        mediaFrame.on('select', function () {
            const attachment = mediaFrame.state().get('selection').first().toJSON();
            $(inputIdFieldSelector).val(attachment.id);
            $(inputUrlFieldSelector).val(attachment.url);
            $imageBox.html('');
            $imageBox.html('<img class="timer-icon-preview timer-icon-preview-js" alt="icon" src="' + attachment.url + '" />');
            mediaFrame.close();

            if($('#develux-timer-builder').length){
                updateGlobalTimerPreview();
            }
            if($('#develux_product_card_timer').length){
                updateMetaboxTimerPreview();
            }
            $('body').find('.develux-update-remove-buttons-wrapper-js').removeClass('hidden');
        });
    });

    // Handle icon removal
    $(document).on('click', removeButtonSelector, function () {
        $(imageContainerSelector).html('');
        $(inputIdFieldSelector).val('');
        $(inputUrlFieldSelector).val('');
        $('body').find('.develux-update-remove-buttons-wrapper-js').addClass('hidden');
        $('.timer-icon-box-js').html(' <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\n' +
            '                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.7197 4.46966L6.46967 9.71966L7.53033 10.7803L11.5 6.81065L11.5 18.5H5.5L5.5 15H4V18.5V20H5.5H11.5H13H18.5H20V18.5V15H18.5V18.5H13L13 6.70037L17.4943 10.8039L18.5057 9.69613L12.7557 4.44613L12.2264 3.96289L11.7197 4.46966Z" fill="#949494"/>\n' +
            '                </svg>');
        if($('#develux-timer-builder').length){
            updateGlobalTimerPreview();
        }
        if($('#develux_product_card_timer').length){
            updateMetaboxTimerPreview();
        }
    });
}
