import * as $ from 'jquery';
import Helper from '../Helper.js';
const helper = new Helper();
export const updateTimerPreview = ()=>{
    // -------------------------------------- Timer ---------------------------------------------------
    const timerTitle = $('#develux-timer-title').val();
    const timerWrapperBgImage = $('#develux-timer-bg-icon-url').val() ?? '';
    const timerWrapperBgColor = $('#develux-timer-container-background-color').val() ?? '';
    const timerWrapperBgColorA = $('#develux-timer-container-background-a').val() ?? '';
    const timerWrapperBG = helper.hexToRgba(timerWrapperBgColor,timerWrapperBgColorA);
    const timerDayName = $('#develux-timer-day-name').val() ?? 'days';
    const timerHourName = $('#develux-timer-hour-name').val() ?? 'hours';
    const timerMinuteName = $('#develux-timer-minute-name').val() ?? 'minutes';
    const timerSecondName = $('#develux-timer-second-name').val() ?? 'seconds';
    const $countDownLocation = $('.countdown-timer-location-js').html('');
    const develuxTimerLocation = $('#develux-timer-location').val() ?? '';
    const $develuxTimerDisplayOnCard = $('#develux-timer-display-on-card');
    const $bottomOuterSpaceContainer = $('.bottom-outer-space-container');

    const $displayOnSingle = $('input[name="develux_timer_display_on_single"]');
    if($displayOnSingle.is(':checked')){
        $('.develux-timer-location-single').attr('disabled',true);
    }else{
        $('.develux-timer-location-single').attr('disabled',false);
    }

    if(
        develuxTimerLocation === 'before_product_card'
        && $develuxTimerDisplayOnCard.is(':checked')
        && !$displayOnSingle.is(':checked')
    ) {
        $bottomOuterSpaceContainer.hide();
        $('#develux-timer-wrapper-margin-bottom').val(0);
    } else {
        $bottomOuterSpaceContainer.show();
    }

    const $timerSchedule = $('input[name="develux_use_single_product_schedule"]');
    if( $timerSchedule.is(':checked') ){
        $('#develux-timer-start-date').attr('disabled',true);
        $('#develux-timer-date').attr('disabled',true);
    }else{
        $('#develux-timer-start-date').attr('disabled',false);
        $('#develux-timer-date').attr('disabled',false);
    }

    const targetSelector = helper.getCountdownTimerLocation(develuxTimerLocation);
    if(targetSelector){
        const generatedTimer = helper.createTimerHTML(timerTitle,timerDayName,timerHourName,timerMinuteName,timerSecondName);
        $('.'+targetSelector).html(generatedTimer);
    }
    $('.countdown-wrapper-js').css({'background':timerWrapperBG});
    if( timerWrapperBgImage ){
        $('.countdown-wrapper-js').css({
            'background-image':'url('+timerWrapperBgImage+')'
        });
    }


    if( develuxTimerLocation === 'before_product_card'){
        $('.countdown-wrapper-js').css({'position':'absolute','left':'0'});
    }else{
        const marginTop = $('#develux-timer-wrapper-top').val();
        $('.countdown-wrapper-js').css({
            'position':'static',
            'left':'0',
            'margin-top':marginTop+'px'
        });
    }

}