import $ from 'jquery';


/**
 * @var develuxsct_DeveluxTimerScript
 */
export const TimerBuilderFormHandler = () => {
    const $timerForm = $('#develux-timer-builder');
    $timerForm.on('keypress', 'input', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });

    $timerForm.on('submit', function (e) {
        e.preventDefault();
        const formData = new FormData(this);
        formData.append('action', develuxsct_DeveluxTimerScript.action_timer_builder_form);
        formData.append('nonce', develuxsct_DeveluxTimerScript.nonce_timer_builder_form);
        $.ajax({
            url: develuxsct_DeveluxTimerScript.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                console.log(response.data);
                window.scrollTo({ top: 0, behavior: 'smooth' });
                $('.develux-success-save-msg').html('<p>Changes are saved successfully</p>');
                setTimeout(function () {
                    location.reload();
                }, 3000);

            },
            error: function (xhr, status, error) {
                console.error(error);
            }
        });
    });

};