import $ from 'jquery';

/**
 * @var develuxsct_DeveluxTimerScript
 */
export const DeleteTimerHandler = ()=>{
    $('.develux-delete-label-permanently-js').on('click',function(e){
        e.preventDefault();
        e.stopPropagation();
        const userConfirmed = confirm('You must understand that you are going to delete your info item permanently.');
        if (!userConfirmed){
            return;
        }
        const id = $(this).data('post-id');
        $.ajax({
            url: develuxsct_DeveluxTimerScript.ajax_url,
            type: 'POST',
            data: {
                action:develuxsct_DeveluxTimerScript.action_delete_timer,
                nonce:develuxsct_DeveluxTimerScript.nonce_delete_timer,
                id:id
            },
            success: function(response) {
                console.log(response.data);
                setTimeout(function() {
                    location.reload();
                }, 1000);
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    });

}