import $ from 'jquery';

/**
 * @var develuxsct_DeveluxTimerScript
 */
export const CreateTimerHandler = ()=>{
    $('#develux-create-timer-form').on('submit',function(e){
        e.preventDefault();
        const title = $('#create-timer').val();
        if (title.trim() === '') {
            alert('Title cannot consist only of whitespace!');
            return;
        }
        const accessNonce = $('#timer_editor_nonce').val();
        const postType = $('#post-type').val();
        const urlBase = $(this).data('url');
        $.ajax({
            url: develuxsct_DeveluxTimerScript.ajax_url,
            type: 'POST',
            data: {
                action:develuxsct_DeveluxTimerScript.action_create_timer,
                nonce:develuxsct_DeveluxTimerScript.nonce_create_timer,
                title:title,
                post_type:postType
            },
            success: function(response) {
                console.log(response.data);
                location.assign(urlBase+response.data.id+'&nonce='+accessNonce);
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    })
}