jQuery(function($){

    // Check/uncheck all categories
    $("#develux-check-all-cats").on('change', function(){
        let all_cat_ids = [];
        if ($("#develux-check-all-cats").is(':checked')) {

            $(".develux-cat-checkbox").each(function(){
                $(this).prop("checked", true);
                all_cat_ids.push($(this).val());
            });

        }else{
            $(".develux-cat-checkbox").each(function(){
                $(this).prop("checked", false);
                all_cat_ids = [];
            });
        }

        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_save_categories',
                nonce: develuxsct_search_product_form.nonce_save_categories,
                cat_list:all_cat_ids.toString(),
                label_id:$('#develux-label-main-id').attr('data-label-id')
            },
            success: function (response) {
                console.log(response);
            }
        });
        return false;

    });

    // Check/uncheck all tags
    $("#develux-check-all-tags").on('change', function(){
        let all_tag_ids = [];
        if ($("#develux-check-all-tags").is(':checked')) {

            $(".develux-tag-checkbox").each(function(){
                $(this).prop("checked", true);
                all_tag_ids.push($(this).val());

            });

        }else{
            $(".develux-tag-checkbox").each(function(){
                $(this).prop("checked", false);
                all_tag_ids = [];
            });
        }

        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_save_tags',
                nonce: develuxsct_search_product_form.nonce_save_tags,
                tag_list:all_tag_ids.toString(),
                label_id:$('#develux-label-main-id').attr('data-label-id')
            },
            success: function (response) {
                console.log(response);
            }
        });
        return false;

    });

    //For tags
    $(document).on('change', '.develux-tag-checkbox', function(){
        const tag_ids = [];
        $(".develux-tag-checkbox").each(function(){
            if ($(this).is(':checked')) {
                tag_ids.push($(this).val());
            }
        });

        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_save_tags',
                nonce: develuxsct_search_product_form.nonce_save_tags,
                tag_list:tag_ids.toString(),
                label_id:$('#develux-label-main-id').attr('data-label-id')
            },
            success: function (response) {
                console.log(response);
            }
        });
        return false;

    });

    //For categories
    $(document).on('change', '.develux-cat-checkbox', function(){
        const cat_ids = [];
        $(".develux-cat-checkbox").each(function(){
            if ($(this).is(':checked')) {
                cat_ids.push($(this).val());
            }
        });

        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_save_categories',
                nonce: develuxsct_search_product_form.nonce_save_categories,
                cat_list:cat_ids.toString(),
                label_id:$('#develux-label-main-id').attr('data-label-id')
            },
            success: function (response) {
                console.log(response);
            }
        });
        return false;

    });

    //Searching product for including
    $(document).on('change keyup', "#develux-search-include-product", function(){
        $('#develux-search-product-icon-exclude').click();
        if( $(this).val().length >= 3 ){
            $('#develux-search-product-icon').attr('src', $('#develux-search-product-icon').attr('data-hide-search'));
            $('#develux-search-product-icon').addClass('develux-hide-search-result');

            let product_ids = [];
            $(".develux-bulk-attached-products .develux-included-prod-to-list").each(function(){
                product_ids.push($(this).attr('data-product-id'));
            });
            $.ajax({
                url: develuxsct_search_product_form.ajax_url,
                type: 'post',
                data: {
                    action: 'develuxsct_search_product',
                    nonce: develuxsct_search_product_form.nonce_search_product,
                    all_product_ids:product_ids.toString(),
                    search_request: $(this).val(),
                    action_type: 'include'
                },
                success: function (response) {
                    $('#develux-product-search-result-cat').html(response);
                    $('#develux-product-search-result-cat').show();
                }
            });
            return false;

        }else{
            $('#develux-search-product-icon').attr('src', $('#develux-search-product-icon').attr('data-search'));
            $('#develux-search-product-icon').removeClass('develux-hide-search-result');
            $('#develux-product-search-result-cat').hide();
        }
    });

    $(document).on('click', '.develux-hide-search-result', function(){
        $('#develux-search-include-product').val('');
        setTimeout(function(){
            $('#develux-product-search-result-cat').hide();
            $('#develux-search-product-icon').attr('src', $('#develux-search-product-icon').attr('data-search'));
        }, 300);
    });

    //Add found product
    $(document).on('click', '.develux-action-add-product-to-include', function(e){
        e.preventDefault();
        let new_product = $(this).attr('data-product-id');
        let product_ids = [];

        $(".develux-bulk-attached-products .develux-included-prod-to-list").each(function(){
            product_ids.push($(this).attr('data-product-id'));
        });

        product_ids.push(new_product);
        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_append_product_to_list',
                nonce: develuxsct_search_product_form.nonce_append_product_to_list,
                product_id: new_product,
                all_product_ids:product_ids.toString(),
                label_id: $('#develux-label-main-id').attr('data-label-id'),
                action_type: 'include'
            },
            success: function (response) {
                $('#develux-append-included-products').append(response);
                $('#develux-product-search-result-cat').find(".develux-action-add-product-to-include[data-product-id='"+new_product+"']").hide();
                $('#develux-product-search-result-cat').find(".develux-action-add-product-to-include[data-product-id='"+new_product+"']").parent().find('.develux-included-product').removeClass('develux-hide-dynamic-item');
            }
        });
        return false;

    });

    $(document).on('click', '.develux-action-remove-product-from-included', function(e){
        e.preventDefault();

        $(this).parent().parent().remove();
        let product_ids = [];
        $(".develux-bulk-attached-products .develux-included-prod-to-list").each(function(){
            product_ids.push($(this).attr('data-product-id'));
        });
        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_update_included_products',
                nonce: develuxsct_search_product_form.nonce_update_included_products,
                all_product_ids:product_ids.toString(),
                label_id: $('#develux-label-main-id').attr('data-label-id'),
                action_type:'include'
            },
            success: function (response) {
            }
        });
        return false;

    });

//----------------------------------------------
    //Exclude processing


    $(document).on('click', '.develux-hide-search-result-exclude', function(){
        $('#develux-search-exclude-product').val('');
        setTimeout(function(){
            $('#develux-product-search-result-cat-excluded').hide();
            $('#develux-search-product-icon-exclude').attr('src', $('#develux-search-product-icon-exclude').attr('data-search'));
        }, 300);
    });

    //Searching product for Exclude
    $(document).on('change keyup', "#develux-search-exclude-product", function(){
        $('#develux-search-product-icon').click();
        if( $(this).val().length >= 3 ){

            $('#develux-search-product-icon-exclude').attr('src', $('#develux-search-product-icon-exclude').attr('data-hide-search'));
            $('#develux-search-product-icon-exclude').addClass('develux-hide-search-result-exclude');

            let excluded_product_ids = [];
            $(".develux-bulk-attached-products .develux-excluded-prod-to-list").each(function(){
                excluded_product_ids.push($(this).attr('data-product-id'));
            });

            $.ajax({
                url: develuxsct_search_product_form.ajax_url,
                type: 'post',
                data: {
                    action: 'develuxsct_search_product',
                    nonce: develuxsct_search_product_form.nonce_search_product,
                    all_product_ids:excluded_product_ids.toString(),
                    search_request: $(this).val(),
                    action_type: 'exclude'
                },
                success: function (response) {
                    $('#develux-product-search-result-cat-excluded').html(response);
                    $('#develux-product-search-result-cat-excluded').show();
                }
            });
            return false;

        }else{
            $('#develux-search-product-icon-exclude').attr('src', $('#develux-search-product-icon-exclude').attr('data-search'));
            $('#develux-search-product-icon-exclude').removeClass('develux-hide-search-result');
            $('#develux-product-search-result-cat-excluded').hide();
        }
    });

    //Add found product to exclude
    $(document).on('click', '.develux-action-add-product-to-exclude', function(e){
        e.preventDefault();

        let new_product = $(this).attr('data-product-id');

        let product_exclude_ids = [];
        $(".develux-bulk-attached-excluded-products .develux-excluded-prod-to-list, .develux-bulk-attached-excluded-products .develux-included-prod-to-list").each(function(){
            product_exclude_ids.push($(this).attr('data-product-id'));
        });

        product_exclude_ids.push(new_product);

        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_append_product_to_list',
                nonce: develuxsct_search_product_form.nonce_append_product_to_list,
                product_id: new_product,
                all_product_ids:product_exclude_ids.toString(),
                label_id: $('#develux-label-main-id').attr('data-label-id'),
                action_type: 'exclude'
            },
            success: function (response) {
                $('#develux-append-excluded-products').append(response);
                $('#develux-product-search-result-cat-excluded').find(".develux-action-add-product-to-exclude[data-product-id='"+new_product+"']").hide();
                $('#develux-product-search-result-cat-excluded').find(".develux-action-add-product-to-exclude[data-product-id='"+new_product+"']").parent().find('.develux-included-product').removeClass('develux-hide-dynamic-item');
            }
        });
        return false;

    });

    $(document).on('click', '.develux-action-remove-product-from-excluded', function(e){
        e.preventDefault();

        $(this).parent().parent().remove();
        let product_ids = [];
        $(".develux-bulk-attached-products .develux-excluded-prod-to-list").each(function(){
            product_ids.push($(this).attr('data-product-id'));
        });
        $.ajax({
            url: develuxsct_search_product_form.ajax_url,
            type: 'post',
            data: {
                action: 'develuxsct_update_included_products',
                nonce: develuxsct_search_product_form.nonce_update_included_products,
                all_product_ids:product_ids.toString(),
                label_id: $('#develux-label-main-id').attr('data-label-id'),
                action_type: 'exclude'
            },
            success: function (response) {
            }
        });
        return false;

    });

});