class Helper{

    generateWritingModeStyles(mode){
        if(mode ==='horizontal_tb'){
            return 'writing-mode:horizontal-tb;';
        }
        if(mode ==='vertical_rl'){
            return 'writing-mode:vertical-rl;';
        }
        if(mode ==='upright'){
            return 'writing-mode:vertical-rl;text-orientation: upright;';
        }
        return '';
    }

    hexToRgba(hex, alpha = 1) {
        if( hex ){
            // Remove the '#' if it's there
            hex = hex.replace(/^#/, '');

            // Parse r, g, b values
            let r = parseInt(hex.substring(0, 2), 16);
            let g = parseInt(hex.substring(2, 4), 16);
            let b = parseInt(hex.substring(4, 6), 16);

            // Return the rgba string with the alpha value
            return `rgba(${r}, ${g}, ${b}, ${alpha})`;
        }
    }

    getAdditionalLabelText(textType,price,salePrice,sku,stock,quantity){
        if( textType === 'none'){
            return '';
        }
        if( textType === 'sku'){
            return sku;
        }
        if( textType === 'percentage'){
            return '-' + this.countPercentage(price,salePrice) + '%';
        }
        if( textType === 'stock'){
            return this.getStockStatus(stock);
        }
        if( textType === 'quantity'){
            return quantity;
        }
        return '';
    }

    getStockStatus(stock){
        if( stock === 'instock'){
            //return 'In stock';
            return '';
        }
        if( stock === 'outofstock'){
            return '';
        }
        if( stock === 'onbackorder'){
            //return 'On back order';
            return '';
        }
        return '';
    }

    countPercentage(price, salePrice) {
        if( price === ''){
            price = 0;
        }
        if( salePrice === ''){
            salePrice = 0;
        }
        const parsedPrice = parseInt(price, 10);
        const parsedSalePrice = parseInt(salePrice, 10);

        if (parsedPrice === 0 || parsedSalePrice === 0) {
            return 0;
        }
        if( parsedPrice > 0 && parsedSalePrice > 0 ){
            return 100 - Math.floor((parsedSalePrice / parsedPrice) * 100);
        }
       return 0;
    }

    getTextAlign(justifyAlign){
        let textAlign = 'left';
        switch (justifyAlign){
            case 'center':
                textAlign = 'center';
                break;
            case 'start':
                textAlign = 'left';
                break;
            case 'end':
                textAlign = 'right';
                break;
        }
        return textAlign;
    }
    getGradient(gradientType, backgroundColorWithAlpha, gradientColorWithAlpha) {
        let gradient;

        switch (gradientType) {
            case 'linear-r-l':
                gradient = `linear-gradient(to left, ${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            case 'linear-l-r':
                gradient = `linear-gradient(to right, ${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            case 'linear-tl-br':
                gradient = `linear-gradient(to bottom right, ${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            case 'linear-tr-bl':
                gradient = `linear-gradient(to bottom left, ${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            case 'radial':
                gradient = `radial-gradient(${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            case 'conic':
                gradient = `conic-gradient(${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
                break;
            default:
                gradient = `linear-gradient(${backgroundColorWithAlpha}, ${gradientColorWithAlpha})`;
        }

        return gradient;
    }

    getSliderNavArrows(type) {
        let left = '<';
        let right = '>';

        switch (type) {
            case 'classic_arrow':
                left = '\u2190';  // ←
                right = '\u2192'; // →
                break;
            case 'double_arrow':
                left = '\u21D0';  // ⇐
                right = '\u21D2'; // ⇒
                break;
            case 'triple_arrow':
                left = '\u21DA';  // ⇚
                right = '\u21DB'; // ⇛
                break;
            case 'angle':
                left = '\u2039';  // ‹
                right = '\u203A'; // ›
                break;
            case 'double_angle':
                left = '\u00AB';  // «
                right = '\u00BB'; // »
                break;
            case 'heavy_angle':
                left = '\u276E';  // ❮
                right = '\u276F'; // ❯
                break;
        }

        return { arrowLeft: left, arrowRight: right };
    }

    getCountdownTimerLocation(location){
        let selector = '';
        switch (location){
            case 'before_product_card':
                selector = 'countdown-timer-before-item';
                break;
            case 'before_product_title':
                selector = 'countdown-timer-before-title';
                break;
            case 'after_product_title':
                selector = 'countdown-timer-after-title';
                break;

        }
        return selector;
    }

    getStdIcon(name){
        let icon = '';
        switch (name) {
            case 'circle':
                icon = '\u25CB'; // Unicode for ○
                break;
            case 'disc':
                icon = '\u25CF'; // Unicode for ●
                break;
            case 'square':
                icon = '\u25FE'; // Unicode for ◾
                break;
        }
        return icon;
    }

    createTimerHTML(timerTitle, dayLabel, hourLabel, minuteLabel, secondLabel) {
        return `
        <div class="countdown-wrapper countdown-wrapper-js">
        <div class="countdown-timer-title-js">${timerTitle}</div>
        <div class="counter countdown-timer-js">
            
            <div class="counter-item">
                <div class="countnum" id="blockDays"></div>
                <div class="counter-title">${dayLabel}</div>
            </div>
            <div class="counter-item">
                <div class="countnum" id="blockHours"></div>
                <div class="counter-title">${hourLabel}</div>
            </div>
            <div class="counter-item">
                <div class="countnum" id="blockMinutes"></div>
                <div class="counter-title">${minuteLabel}</div>
            </div>
            <div class="counter-item">
                <div class="countnum" id="blockSeconds"></div>
                <div class="counter-title">${secondLabel}</div>
            </div>
        </div>
        </div>
    `;
    }

    getMinus(color,size){
        return '<svg width="'+size+'" height="'+size+'" viewBox="0 0 14 2" fill="none" xmlns="http://www.w3.org/2000/svg">\n' +
            '<path d="M1 1L13 0.999999" stroke="' + color + '" stroke-width="1.6" stroke-linecap="round"/>\n' +
            '</svg>';

    }
    getPlus(color,size){
        return '<svg width="'+size+'" height="'+size+'" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">\n' +
            '<path d="M7 1V13" stroke="' + color + '" stroke-width="1.6" stroke-linecap="round"/>\n' +
            '<path d="M1 7L13 7" stroke="' + color + '" stroke-width="1.6" stroke-linecap="round"/>\n' +
            '</svg>';
    }


}
export default Helper;