<?php

namespace DEVELUXSCT\Widgets;
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
class ProductWidget
{
    public function __construct()
    {
        add_action('add_meta_boxes', [$this, 'customAddMetaBox']);
        add_action('save_post', [$this, 'saveCustomProductData']);
        add_action('woocommerce_single_product_summary', [$this, 'display_custom_product_data'], 25);


        add_action('save_post', [$this, 'namespaceSaveRevisions']);
        add_action('wp_restore_post_revision', [$this, 'namespaceRestoreRevisions'], 10, 2);
        add_filter('_wp_post_revision_fields', [$this, 'namespaceGetRevisionsFields']);
    }

    public function namespaceGetRevisionsFields($fields)
    {
        // Set a title
        $fields['_custom_field_value'] = 'Some Item';
        return $fields;
    }

    public function namespaceRestoreRevisions($post_id, $revision_id)
    {
        // Variables
        $post = get_post($post_id); // The post
        $revision = get_post($revision_id); // The revision
        $details = get_metadata('post', $revision->ID, '_custom_field_value', true); // The historic version

        // Replace our saved data with the old version
        update_post_meta($post_id, '_custom_field_value', $details);

    }

    public function namespaceSaveRevisions($post_id)
    {

        // Check if it's a revision
        $parent_id = wp_is_post_revision($post_id);

        // If is revision
        if ($parent_id) {

            // Get the saved data
            $parent = get_post($parent_id);
            $details = get_post_meta($parent->ID, '_custom_field_value', true);

            // If data exists and is an array, add to revision
            if (!empty($details)) {
                add_metadata('post', $post_id, '_custom_field_value', $details);
            }

        }

    }

    //----------------
    public function customAddMetaBox()
    {
        add_meta_box(
            'develux_product_card_customizer', // Unique ID
            'Product card customizer', // Box title
            [$this, 'customProductDataCallback'], // Content callback
            'product', // Post type
            'normal', // Context
            'high' // Priority
        );
    }

    public function customProductDataCallback($post)
    {
        wp_nonce_field(basename(__FILE__), 'custom_product_data_nonce');
        $custom_field_value = get_post_meta($post->ID, '_custom_field_value', true);
        ?>
        <p>
            <label for="custom_field_value">Custom Field:</label>
            <input type="text" name="custom_field_value" id="custom_field_value"
                   value="<?php echo esc_attr($custom_field_value); ?>"/>
        </p>
        <?php
    }

    public function saveCustomProductData($post_id)
    {
        if (!isset($_POST['custom_product_data_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['custom_product_data_nonce'])), basename(__FILE__))) {
            return $post_id;
        }
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        if (isset($_POST['post_type']) && 'product' !== sanitize_text_field(wp_unslash($_POST['post_type']))) {
            return $post_id;
        }
        if (!current_user_can('edit_post', $post_id)) {
            return $post_id;
        }

        if ($parent_id = wp_is_post_revision($post_id)) {
            $post_id = $parent_id;
        }

        $new_value = (isset($_POST['custom_field_value']) ? sanitize_text_field(wp_unslash($_POST['custom_field_value'])) : '');

        update_post_meta($post_id, '_custom_field_value', $new_value);
    }

    public function display_custom_product_data()
    {
        global $post;
        $custom_field_value = get_post_meta($post->ID, '_custom_field_value', true);
        if (!empty($custom_field_value)) {
            echo '<p>Custom Field Value: ' . esc_html($custom_field_value) . '</p>';
        }
    }


}
