<?php
namespace DEVELUXSCT\WC_Settings;
class WC_Timer_Select {
    public function __construct() {
        add_action('woocommerce_product_options_pricing', [$this, 'add_custom_timer_field_after_sale_dates']);
        add_action('woocommerce_process_product_meta', [$this, 'save_custom_timer_field']);
    }

    public function add_custom_timer_field_after_sale_dates(): void
    {
        echo '<div class="options_group">';

        // Select field: Develux Timers
        $timers = get_posts([
            'post_type'      => 'develuxsct_timer',
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        ]);

        $options = ['' => __('Select a Timer', 'devellux-sales-countdown-timer-builder')];
        foreach ($timers as $timer) {
            $options[$timer->ID] = $timer->post_title;
        }

        woocommerce_wp_select([
            'id'          => 'develux_timer_select',
            'label'       => __('Timer Template', 'devellux-sales-countdown-timer-builder'),
            'options'     => $options,
            'desc_tip'    => true,
            'description' => __('Selecting a timer template for the product.', 'devellux-sales-countdown-timer-builder'),
        ]);

        echo '</div>';
    }

    public function save_custom_timer_field($post_id): void
    {
        // phpcs:ignore WordPress.Security.NonceVerification.Missing
        if (isset($_POST['develux_timer_select'])) {
            // phpcs:ignore WordPress.Security.NonceVerification.Missing
            update_post_meta($post_id, 'develux_timer_select', (int)(sanitize_text_field(wp_unslash($_POST['develux_timer_select']))));
        }
    }
}